/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.client.model;

import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.Reference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;

public final class JiraBuildInfo {
    private static final String SCHEMA_VERSION = "1.0";
    private final String pipelineId;
    private final Integer buildNumber;
    private final Long updateSequenceNumber;
    private final String displayName;
    private final String description;
    private final String label;
    private final String url;
    private final String state;
    private final String lastUpdated;
    private final Set<String> issueKeys;
    private final List<Reference> references;

    @JsonCreator
    public JiraBuildInfo(@JsonProperty(value="pipelineId") String pipelineId, @JsonProperty(value="buildNumber") Integer buildNumber, @JsonProperty(value="updateSequenceNumber") Long updateSequenceNumber, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="description") String description, @JsonProperty(value="label") String label, @JsonProperty(value="url") String url, @JsonProperty(value="state") String state, @JsonProperty(value="lastUpdated") String lastUpdated, @JsonProperty(value="issueKeys") Set<String> issueKeys, @JsonProperty(value="references") List<Reference> references) {
        this.pipelineId = pipelineId;
        this.buildNumber = buildNumber;
        this.updateSequenceNumber = updateSequenceNumber;
        this.displayName = displayName;
        this.description = description;
        this.label = label;
        this.url = url;
        this.state = state;
        this.lastUpdated = lastUpdated;
        this.issueKeys = issueKeys;
        this.references = references;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    public Long getUpdateSequenceNumber() {
        return this.updateSequenceNumber;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public String getState() {
        return this.state;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pipelineId;
        private Integer buildNumber;
        private Long updateSequenceNumber;
        private String displayName;
        private String description;
        private String label;
        private String url;
        private String state;
        private String lastUpdated;
        private Set<String> issueKeys;
        private List<Reference> references;

        public Builder withPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public Builder withBuildNumber(Integer buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        public Builder withUpdateSequenceNumber(Long updateSequenceNumber) {
            this.updateSequenceNumber = updateSequenceNumber;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withLastUpdated(String lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder withIssueKeys(Set<String> issueKeys) {
            this.issueKeys = ImmutableSet.copyOf(issueKeys);
            return this;
        }

        public Builder withReferences(List<Reference> references) {
            this.references = ImmutableList.copyOf(references);
            return this;
        }

        public JiraBuildInfo build() {
            return new JiraBuildInfo(this.pipelineId, this.buildNumber, this.updateSequenceNumber, this.displayName, this.description, this.label, this.url, this.state, this.lastUpdated, this.issueKeys, this.references);
        }
    }
}

