/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cloud.jenkins.buildinfo.client;

import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.Builds;
import com.atlassian.jira.cloud.jenkins.buildinfo.client.model.JiraBuildInfo;
import com.atlassian.jira.cloud.jenkins.util.JenkinsToJiraStatus;
import hudson.AbortException;
import java.time.Instant;
import java.util.Set;
import org.jenkinsci.plugins.workflow.support.steps.build.RunWrapper;

public final class BuildPayloadBuilder {
    public static Builds getBuildPayload(RunWrapper buildWrapper, Set<String> issueKeys) {
        try {
            return new Builds(JiraBuildInfo.builder().withPipelineId(buildWrapper.getFullProjectName()).withBuildNumber(buildWrapper.getNumber()).withDisplayName(buildWrapper.getDisplayName()).withUpdateSequenceNumber(Instant.now().getEpochSecond()).withLabel(buildWrapper.getDisplayName()).withUrl(buildWrapper.getAbsoluteUrl()).withState(JenkinsToJiraStatus.getStatus(buildWrapper.getCurrentResult())).withLastUpdated(Instant.now().toString()).withIssueKeys(issueKeys).build());
        }
        catch (AbortException e) {
            throw new RuntimeException(e);
        }
    }
}

