/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.authentication;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.authentication.AuthMethod;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public abstract class AuthenticationContext
implements Serializable {
    private String name;
    private ValidationFactor[] validationFactors;
    private AuthMethod authMethod;

    protected AuthenticationContext() {
    }

    protected AuthenticationContext(String name, @Nullable AuthMethod authMethod, ValidationFactor[] validationFactors) {
        this.name = name;
        this.authMethod = authMethod instanceof PasswordCredential ? AuthenticationContext.checkNotEncrypted((PasswordCredential)authMethod) : authMethod;
        this.validationFactors = validationFactors;
    }

    private static PasswordCredential checkNotEncrypted(PasswordCredential credential) {
        if (credential != null && credential.isEncryptedCredential()) {
            throw new IllegalArgumentException("Password credentials must not be encrypted");
        }
        return credential;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuthMethod getAuthMethod() {
        return this.authMethod;
    }

    @Nullable
    @Deprecated
    public PasswordCredential getCredential() {
        return this.authMethod instanceof PasswordCredential ? (PasswordCredential)this.authMethod : null;
    }

    public void setCredential(PasswordCredential credential) {
        this.authMethod = AuthenticationContext.checkNotEncrypted(credential);
    }

    public ValidationFactor[] getValidationFactors() {
        return this.validationFactors;
    }

    public void setValidationFactors(ValidationFactor[] validationFactors) {
        this.validationFactors = validationFactors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationContext that = (AuthenticationContext)o;
        if (!Objects.equals(this.authMethod, that.authMethod)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Arrays.equals(this.validationFactors, that.validationFactors);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.authMethod != null ? this.authMethod.hashCode() : 0);
        result = 31 * result + (this.validationFactors != null ? Arrays.hashCode(this.validationFactors) : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("authMethod", (Object)this.authMethod).append("validationFactors", (Object[])this.validationFactors).toString();
    }
}

