/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryEntities {
    private static final Logger log = LoggerFactory.getLogger(DirectoryEntities.class);
    public static final Function<DirectoryEntity, String> NAME_FUNCTION = DirectoryEntity::getName;
    public static final Function<DirectoryEntity, String> LOWER_NAME_FUNCTION = NAME_FUNCTION.andThen(IdentifierUtils.TO_LOWER_CASE);

    public static List<String> namesOf(Collection<? extends DirectoryEntity> entities) {
        return entities.stream().map(NAME_FUNCTION).collect(Collectors.toList());
    }

    public static <T extends DirectoryEntity> List<T> filterOutDuplicates(List<T> remoteEntities) {
        return DirectoryEntities.filterOutDuplicates(remoteEntities, DirectoryEntity::getName);
    }

    public static <T> List<T> filterOutDuplicates(Collection<T> remoteEntities, Function<T, String> nameProvider) {
        LinkedHashMap<String, T> entityMap = new LinkedHashMap<String, T>();
        HashSet<String> badEntities = new HashSet<String>();
        for (T remoteEntity : remoteEntities) {
            T origEntity;
            String remoteName = nameProvider.apply(remoteEntity);
            String entityId = IdentifierUtils.toLowerCase((String)remoteName);
            if (badEntities.contains(entityId) || (origEntity = entityMap.put(entityId, remoteEntity)) == null) continue;
            entityMap.remove(entityId);
            badEntities.add(entityId);
            String origName = nameProvider.apply(origEntity);
            if (!origName.equals(remoteName)) {
                log.warn("entity [{}] of type {} duplicated in remote directory by entity [{}]. Ignoring all occurrences.", new Object[]{origName, remoteEntity.getClass().getSimpleName(), remoteName});
                continue;
            }
            log.warn("entity [{}] of type {} duplicated in remote directory. Ignoring all occurrences.", (Object)origName, (Object)remoteEntity.getClass().getSimpleName());
        }
        return badEntities.isEmpty() && remoteEntities instanceof List ? (List)remoteEntities : new ArrayList(entityMap.values());
    }
}

