/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.model.group.BaseImmutableGroup;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import java.util.Date;
import java.util.Objects;

public class ImmutableDirectoryGroup
extends BaseImmutableGroup
implements InternalDirectoryGroup {
    private final Date createdDate;
    private final Date updatedDate;
    private final boolean isLocal;

    private ImmutableDirectoryGroup(Builder builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.updatedDate = builder.updatedDate;
        this.isLocal = builder.isLocal;
    }

    public static ImmutableDirectoryGroup from(InternalDirectoryGroup group) {
        if (group instanceof ImmutableDirectoryGroup) {
            return (ImmutableDirectoryGroup)group;
        }
        return ImmutableDirectoryGroup.builder(group).build();
    }

    @Override
    public ImmutableDirectoryGroup withName(String name) {
        return ((Builder)ImmutableDirectoryGroup.builder(this).setName(name)).build();
    }

    public static Builder builder(InternalDirectoryGroup group) {
        return new Builder(group);
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    @Override
    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImmutableDirectoryGroup that = (ImmutableDirectoryGroup)o;
        return Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.updatedDate, that.updatedDate) && this.isLocal == that.isLocal;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.createdDate, this.updatedDate, this.isLocal);
    }

    public static class Builder
    extends BaseImmutableGroup.Builder<Builder> {
        private Date createdDate;
        private Date updatedDate;
        private boolean isLocal;

        private Builder(InternalDirectoryGroup group) {
            super(group);
            this.setCreatedDate(group.getCreatedDate());
            this.setUpdatedDate(group.getUpdatedDate());
            this.setLocal(group.isLocal());
        }

        public Builder setCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder setUpdatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public Builder setLocal(boolean local) {
            this.isLocal = local;
            return this;
        }

        @Override
        public ImmutableDirectoryGroup build() {
            return new ImmutableDirectoryGroup(this);
        }
    }
}

