/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.model.application.RemoteAddress;

public class RemoteAddressHelper {
    private static final String CIDR_REGEX = "\\d+\\.\\d+\\.\\d+\\.\\d+\\/\\d+";
    private static final String IP_REGEX = "\\d+\\.\\d+\\.\\d+\\.\\d+";

    public static boolean isCidrNotation(String address) {
        return address.matches(CIDR_REGEX);
    }

    public static boolean isIpAddressNotation(String address) {
        return address.matches(IP_REGEX);
    }

    public static boolean isAddressAllowed(RemoteAddress allowedAddress, RemoteAddress requestAddress) {
        String requestIpAddress;
        String allowedIpAddress = allowedAddress.getAddress();
        boolean isAllowed = allowedIpAddress.equals(requestIpAddress = requestAddress.getAddress());
        if (!isAllowed) {
            String allowedMaskedBinary = allowedAddress.getBinaryAddress();
            String requestAddressBinary = requestAddress.getBinaryAddress();
            if (allowedMaskedBinary != null && requestAddressBinary != null) {
                isAllowed = requestAddressBinary.startsWith(allowedMaskedBinary);
            }
        }
        return isAllowed;
    }

    public static String maskedAddressInBinary(String address) {
        String[] cidrSplit = address.split("\\/");
        String ipAddress = RemoteAddressHelper.addressInBinary(cidrSplit[0]);
        int mask = Integer.valueOf(cidrSplit[1]);
        return ipAddress.substring(0, mask);
    }

    public static String addressInBinary(String address) {
        String[] blocks;
        StringBuilder binaryAddress = new StringBuilder();
        for (String block : blocks = address.split("\\.")) {
            binaryAddress.append(RemoteAddressHelper.toEightBitBinary(block));
        }
        return binaryAddress.toString();
    }

    private static String toEightBitBinary(String block) {
        int blockValue = Integer.parseInt(block);
        StringBuilder eightBitBinary = new StringBuilder(Integer.toBinaryString(blockValue));
        while (eightBitBinary.length() < 8) {
            eightBitBinary.insert(0, "0");
        }
        return eightBitBinary.toString();
    }
}

