/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.cache.GroupCache;
import com.atlassian.crowd.integration.service.cache.GroupMembershipCache;
import com.atlassian.crowd.integration.service.cache.Null;
import com.atlassian.crowd.integration.service.cache.UserCache;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import org.apache.log4j.Logger;

public class CacheImpl
implements UserCache,
GroupCache,
GroupMembershipCache {
    private final Logger logger = Logger.getLogger(this.getClass());
    private CacheManager ehCacheManager;
    private static final String USER_CACHE = "com.atlassian.crowd.integration-user";
    private static final String USERNAMES_CACHE = "com.atlassian.crowd.integration-usernames";
    private static final String GROUP_CACHE = "com.atlassian.crowd.integration-group";
    private static final String GROUPNAMES_CACHE = "com.atlassian.crowd.integration-groupnames";
    private static final String PARENT_GROUPS_CACHE = "com.atlassian.crowd.integration-parentgroup";
    private static final String GROUP_MEMBERSHIP_CACHE = "com.atlassian.crowd.integration-group-membership";
    private static final String ALL_USER_MEMBERSHIPS_CACHE = "com.atlassian.crowd.integration-all-memberships";
    private static final String ALL_GROUP_MEMBERS_CACHE = "com.atlassian.crowd.integration-all-group-members";
    private static final String USERNAMES_KEY = "usernames";
    private static final String GROUPNAMES_KEY = "groupnames";

    public CacheImpl() {
        URL url = this.getClass().getResource("/crowd-ehcache.xml");
        this.ehCacheManager = CacheManager.create((URL)url);
        this.createIfNeeded(url, USER_CACHE);
        this.createIfNeeded(url, USERNAMES_CACHE);
        this.createIfNeeded(url, GROUP_CACHE);
        this.createIfNeeded(url, GROUPNAMES_CACHE);
        this.createIfNeeded(url, PARENT_GROUPS_CACHE);
        this.createIfNeeded(url, GROUP_MEMBERSHIP_CACHE);
        this.createIfNeeded(url, ALL_USER_MEMBERSHIPS_CACHE);
        this.createIfNeeded(url, ALL_GROUP_MEMBERS_CACHE);
    }

    private void createIfNeeded(URL url, String cacheName) {
        ConfigurationHelper helper;
        Set caches;
        Configuration configuration;
        if (!this.ehCacheManager.cacheExists(cacheName) && url != null && (configuration = ConfigurationFactory.parseConfiguration((URL)url)) != null && !(caches = (helper = new ConfigurationHelper(this.ehCacheManager, configuration)).createCaches()).isEmpty()) {
            for (Cache cache : caches) {
                if (this.ehCacheManager.cacheExists(cache.getName())) continue;
                this.ehCacheManager.addCache(cache);
            }
        }
        if (!this.ehCacheManager.cacheExists(cacheName)) {
            this.ehCacheManager.addCache(cacheName);
        }
    }

    private Cache getUserCache() {
        return this.ehCacheManager.getCache(USER_CACHE);
    }

    private Cache getUserNamesCache() {
        return this.ehCacheManager.getCache(USERNAMES_CACHE);
    }

    private Cache getGroupCache() {
        return this.ehCacheManager.getCache(GROUP_CACHE);
    }

    private Cache getGroupNamesCache() {
        return this.ehCacheManager.getCache(GROUPNAMES_CACHE);
    }

    private Cache getParentGroupsCache() {
        return this.ehCacheManager.getCache(PARENT_GROUPS_CACHE);
    }

    private Cache getGroupMembershipCache() {
        return this.ehCacheManager.getCache(GROUP_MEMBERSHIP_CACHE);
    }

    private Cache getUserMembershipsCache() {
        return this.ehCacheManager.getCache(ALL_USER_MEMBERSHIPS_CACHE);
    }

    private Cache getGroupMembersCache() {
        return this.ehCacheManager.getCache(ALL_GROUP_MEMBERS_CACHE);
    }

    public void flush() {
        this.ehCacheManager.clearAll();
    }

    public void addOrReplaceUser(SOAPPrincipal user) {
        this.getUserCache().put(new Element((Serializable)((Object)user.getName()), (Serializable)user));
    }

    public boolean removeUser(String userName) {
        return this.getUserCache().remove((Serializable)((Object)userName));
    }

    public SOAPPrincipal getUser(String userName) {
        Element element = this.getUserCache().get((Serializable)((Object)userName));
        if (element == null) {
            return null;
        }
        return (SOAPPrincipal)element.getValue();
    }

    public List getAllUserNames() {
        Element element = this.getUserNamesCache().get((Serializable)((Object)USERNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllUserNames(List userNames) {
        this.getUserNamesCache().put(new Element((Object)USERNAMES_KEY, (Object)userNames));
    }

    public SOAPGroup getGroup(String groupName) {
        Element element = this.getGroupCache().get((Serializable)((Object)groupName));
        if (element == null) {
            return null;
        }
        return (SOAPGroup)element.getValue();
    }

    public void addOrReplaceGroup(SOAPGroup group) {
        this.getGroupCache().put(new Element((Serializable)((Object)group.getName()), (Serializable)group));
    }

    public void removeGroup(String groupName) {
        this.getGroupCache().remove((Serializable)((Object)groupName));
    }

    public List getAllGroupNames() {
        Element element = this.getGroupNamesCache().get((Serializable)((Object)GROUPNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllGroupNames(List groupNames) {
        this.getGroupNamesCache().put(new Element((Object)GROUPNAMES_KEY, (Object)groupNames));
    }

    public void addParentForGroup(String childGroup, String parentGroup) {
        Element element = this.getParentGroupsCache().get((Serializable)((Object)childGroup));
        if (element != null) {
            ArrayList parents = (ArrayList)element.getValue();
            if (!parents.contains(parentGroup)) {
                parents.add(parentGroup);
            }
        } else {
            ArrayList<String> parentGroups = new ArrayList<String>(1);
            parentGroups.add(parentGroup);
            element = new Element((Serializable)((Object)childGroup), parentGroups);
            this.getParentGroupsCache().put(element);
        }
    }

    public List getParentGroups(String childGroup) {
        Element element = this.getParentGroupsCache().get((Serializable)((Object)childGroup));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public boolean containsGroupRelationships() {
        return this.getAllGroupNames() != null;
    }

    public void setMembership(String userName, String groupName, Boolean isMember) {
        Null.not(isMember);
        this.getGroupMembershipCache().put(new Element((Serializable)new UserGroupKey(userName, groupName), (Serializable)isMember));
    }

    public void removeMembership(String userName, String groupName) {
        this.getGroupMembershipCache().remove((Serializable)new UserGroupKey(userName, groupName));
    }

    public Boolean isMember(String userName, String groupName) {
        Element element = this.getGroupMembershipCache().get((Serializable)new UserGroupKey(userName, groupName));
        if (element == null) {
            return null;
        }
        return (Boolean)element.getValue();
    }

    public List getAllMemberships(String userName) {
        Element element = this.getUserMembershipsCache().get((Serializable)((Object)userName));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllMemberships(String userName, List groupNames) {
        this.getUserMembershipsCache().put(new Element((Object)userName, (Object)groupNames));
    }

    public void removeAllMemberships(String userName) {
        this.getUserMembershipsCache().remove((Serializable)((Object)userName));
    }

    public List getAllMembers(String groupName) {
        Element element = this.getGroupMembersCache().get((Serializable)((Object)groupName));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    public void addOrReplaceAllMembers(String groupName, List userNames) {
        this.getGroupMembersCache().put(new Element((Object)groupName, (Object)userNames));
    }

    public void removeAllMembers(String groupName) {
        this.getGroupMembersCache().remove((Serializable)((Object)groupName));
    }

    class UserGroupKey
    implements Serializable {
        String userName;
        String groupName;

        UserGroupKey(String userName, String groupName) {
            Null.not(userName);
            Null.not(groupName);
            this.userName = userName;
            this.groupName = groupName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UserGroupKey)) {
                return false;
            }
            UserGroupKey other = (UserGroupKey)o;
            return this.userName.equals(other.userName) && this.groupName.equals(other.groupName);
        }

        public int hashCode() {
            return this.userName.hashCode() / 2 + this.groupName.hashCode() / 2;
        }
    }
}

