/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.cache.GroupCache;
import com.atlassian.crowd.integration.service.cache.Null;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;

public class NestingHelper {
    public static List getAllGroupNames(SOAPNestableGroup[] allGroups, GroupCache cache) {
        Null.not(allGroups);
        ArrayList<String> groupNames = new ArrayList<String>(allGroups.length);
        boolean atLeastOneNestedGroup = false;
        for (int i = 0; i < allGroups.length; ++i) {
            groupNames.add(allGroups[i].getName());
            if (!NestingHelper.cacheRelationships(allGroups[i], cache)) continue;
            atLeastOneNestedGroup = true;
        }
        cache.addOrReplaceAllGroupNames(groupNames);
        if (atLeastOneNestedGroup) {
            NestingHelper.buildCompleteParentRelationships(cache);
        }
        return groupNames;
    }

    private static boolean cacheRelationships(SOAPNestableGroup group, GroupCache cache) {
        boolean atLeastOneParent = false;
        String[] children = group.getGroupMembers();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                cache.addParentForGroup(children[i], group.getName());
                atLeastOneParent = true;
            }
        }
        return atLeastOneParent;
    }

    private static void buildCompleteParentRelationships(GroupCache cache) {
        List allGroups = cache.getAllGroupNames();
        for (String groupName : allGroups) {
            List parents = cache.getParentGroups(groupName);
            if (parents == null) continue;
            ArrayList directParents = new ArrayList(parents);
            ListIterator parentIt = directParents.listIterator();
            while (parentIt.hasNext()) {
                NestingHelper.addMoreParents(groupName, (String)parentIt.next(), parents, cache);
            }
        }
    }

    private static void addMoreParents(String childGroup, String parentGroup, List allParentGroups, GroupCache cache) {
        List moreParentGroups = cache.getParentGroups(parentGroup);
        if (moreParentGroups != null) {
            for (String anotherParent : moreParentGroups) {
                if (allParentGroups.contains(anotherParent) || childGroup.equals(anotherParent)) continue;
                allParentGroups.add(anotherParent);
                NestingHelper.addMoreParents(childGroup, anotherParent, allParentGroups, cache);
            }
        }
    }

    public static List getAllGroupsForUser(List directGroups, GroupCache cache) {
        if (directGroups == null) {
            return null;
        }
        HashSet<String> allGroups = new HashSet<String>(directGroups);
        for (String groupName : directGroups) {
            allGroups.add(groupName);
            List parents = cache.getParentGroups(groupName);
            if (parents == null) continue;
            allGroups.addAll(parents);
        }
        return new ArrayList(allGroups);
    }
}

