/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.AuthenticationManagerImpl;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManager;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManagerImpl;
import com.atlassian.crowd.integration.service.cache.CachingGroupManager;
import com.atlassian.crowd.integration.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.CachingUserManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;

public class CachingManagerFactory {
    public static AuthenticationManager getAuthenticationManagerInstance() {
        return AuthenticationManagerHolder.authenticationManager;
    }

    public static UserManager getUserManagerInstance() {
        return CachingManagerHolder.userManager;
    }

    public static GroupManager getGroupManagerInstance() {
        return CachingManagerHolder.groupManager;
    }

    public static GroupMembershipManager getGroupMembershipManagerInstance() {
        return CachingManagerHolder.groupMembershipManager;
    }

    public static CacheExpiryManager getCacheExpiryManagerInstance() {
        return CacheExpiryManagerHolder.cacheExpiryManager;
    }

    private static class CacheExpiryManagerHolder {
        private static final CacheExpiryManager cacheExpiryManager = new CacheExpiryManagerImpl();

        private CacheExpiryManagerHolder() {
        }
    }

    private static class CachingManagerHolder {
        private static final CachingGroupMembershipManager groupMembershipManager = new CachingGroupMembershipManager(SecurityServerClientFactory.getSecurityServerClient());
        private static final CachingGroupManager groupManager = new CachingGroupManager(SecurityServerClientFactory.getSecurityServerClient());
        private static final CachingUserManager userManager = new CachingUserManager(SecurityServerClientFactory.getSecurityServerClient());

        private CachingManagerHolder() {
        }

        static {
            userManager.setCachingGroupMembershipManager(groupMembershipManager);
            groupManager.setCachingGroupMembershipManager(groupMembershipManager);
            groupMembershipManager.setCachingGroupManager(groupManager);
        }
    }

    private static class AuthenticationManagerHolder {
        private static final AuthenticationManager authenticationManager = new AuthenticationManagerImpl(SecurityServerClientFactory.getSecurityServerClient());

        private AuthenticationManagerHolder() {
        }
    }
}

