/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.crowd.util.SecureRandomStringUtils;
import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PasswordHelperImpl
implements PasswordHelper {
    public boolean validateRegex(String regex, PasswordCredential credential) {
        if (((PasswordCredential)Preconditions.checkNotNull((Object)credential)).isEncryptedCredential()) {
            return false;
        }
        return StringUtils.isBlank((CharSequence)regex) || credential.getCredential() != null && Pattern.compile(regex).matcher(credential.getCredential()).find();
    }

    public String generateRandomPassword() {
        return SecureRandomStringUtils.getInstance().randomAlphanumericString(22);
    }
}

