/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.lock;

import com.atlassian.crowd.manager.lock.LockFactory;
import com.atlassian.crowd.manager.lock.ReentrantLockFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;

public class DirectoryLockManager {
    private static final String KEY_PREFIX = DirectoryLockManager.class.getName() + ".directory-";
    private final LockFactory lockFactory;
    private final Map<String, Lock> locks;

    public DirectoryLockManager() {
        this(new ReentrantLockFactory());
    }

    public DirectoryLockManager(LockFactory lockFactory) {
        this.lockFactory = lockFactory;
        this.locks = new HashMap<String, Lock>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(long directoryId) {
        String key = DirectoryLockManager.getLockKey(directoryId);
        Map<String, Lock> map = this.locks;
        synchronized (map) {
            Lock lock = this.locks.get(key);
            if (lock == null) {
                lock = this.lockFactory.getLock(key);
                this.locks.put(key, lock);
            }
            return lock;
        }
    }

    private static String getLockKey(long directoryId) {
        return KEY_PREFIX + directoryId;
    }
}

