/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.directory.monitor.poller.DirectoryPoller;
import com.atlassian.crowd.manager.directory.monitor.DirectoryMonitorRegistrationException;
import com.atlassian.crowd.manager.directory.monitor.poller.AbstractQuartzDirectoryPollerManager;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJob;
import java.util.Date;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class QuartzDirectoryPollerManager
extends AbstractQuartzDirectoryPollerManager {
    private final Scheduler scheduler;

    public QuartzDirectoryPollerManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    protected JobDetail buildJobDetail(DirectoryPoller poller) throws DirectoryMonitorRegistrationException {
        JobDataMap jobData = new JobDataMap();
        jobData.put("DIRECTORY_POLLER", (Object)poller);
        JobBuilder jobBuilder = JobBuilder.newJob(DirectoryPollerJob.class).withIdentity(this.getJobName(poller.getDirectoryID()), "DirectoryPoller").storeDurably(true).usingJobData(jobData);
        return jobBuilder.build();
    }

    @Override
    protected Trigger buildTrigger(DirectoryPoller poller, JobDetail jobDetail) throws DirectoryMonitorRegistrationException {
        SimpleScheduleBuilder sched = SimpleScheduleBuilder.simpleSchedule().repeatForever().withIntervalInSeconds((int)poller.getPollingInterval());
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(jobDetail.getKey().getName(), jobDetail.getKey().getGroup()).forJob(jobDetail).withSchedule((ScheduleBuilder)sched).startAt(new Date(System.currentTimeMillis() + 5000L));
        return triggerBuilder.build();
    }

    @Override
    protected Scheduler getScheduler() {
        return this.scheduler;
    }
}

