/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.I18nHelperConfiguration;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nHelperImpl
implements I18nHelper {
    private static final Logger LOG = LoggerFactory.getLogger(I18nHelperImpl.class);
    private final Locale locale;
    private final List<String> i18nLocations;

    public I18nHelperImpl(I18nHelperConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.locale = (Locale)Preconditions.checkNotNull((Object)configuration.getLocale());
        this.i18nLocations = (List)Preconditions.checkNotNull((Object)configuration.getBundleLocations());
    }

    public String getText(String key) {
        return this.getText(key, new Object[0]);
    }

    public String getText(String key, String value1) {
        return this.getText(key, Arrays.asList(value1));
    }

    public String getText(String key, String value1, String value2) {
        return this.getText(key, Arrays.asList(value1, value2));
    }

    public String getText(String key, Object parameters) {
        Object[] params = parameters instanceof List ? ((List)parameters).toArray() : (parameters instanceof Object[] ? (Object[])parameters : new Object[]{parameters});
        return new MessageFormat(this.getUnescapedText(key)).format(params);
    }

    public String getUnescapedText(String key) {
        for (String i18nLocation : this.i18nLocations) {
            try {
                ResourceBundle rb = this.getResourceBundle(i18nLocation);
                if (key.startsWith("'") && key.endsWith("'")) {
                    key = key.substring(1, key.length() - 1);
                }
                try {
                    return rb.getString(key);
                }
                catch (MissingResourceException e) {
                    LOG.debug("Key not present<" + key + "> in bundle <" + i18nLocation + ">");
                }
            }
            catch (MissingResourceException e) {
                LOG.error("Cannot load resource bundle with location '" + i18nLocation + "'.", (Throwable)e);
            }
        }
        return key;
    }

    private ResourceBundle getResourceBundle(String i18nLocation) {
        return ResourceBundle.getBundle(i18nLocation, this.locale);
    }
}

