/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.cache;

import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.CacheManagerException;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManagerEhcache
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(CacheManagerEhcache.class);
    private String DEFAULT_CACHE = CacheManagerEhcache.class.getName();
    private final net.sf.ehcache.CacheManager cacheManager;

    public CacheManagerEhcache(net.sf.ehcache.CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void configureCaches() {
        this.configureCache(this.DEFAULT_CACHE);
    }

    protected void configureCache(String cacheName) {
        try {
            if (!this.cacheManager.cacheExists(cacheName)) {
                this.cacheManager.addCache(cacheName);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected Cache getCache(String cacheName) {
        this.configureCache(cacheName);
        return this.cacheManager.getCache(cacheName);
    }

    public Object get(String key) throws CacheManagerException, NotInCacheException {
        return this.get(this.DEFAULT_CACHE, (Serializable)((Object)key));
    }

    public void put(String key, Serializable obj) throws CacheManagerException {
        this.put(this.DEFAULT_CACHE, (Serializable)((Object)key), obj);
    }

    public boolean remove(String key) throws CacheManagerException {
        return this.remove(this.DEFAULT_CACHE, (Serializable)((Object)key));
    }

    public void removeAll() throws CacheManagerException {
        this.removeAll(this.DEFAULT_CACHE);
    }

    public List getAllKeys() throws CacheManagerException {
        return this.getAllKeys(this.DEFAULT_CACHE);
    }

    public void put(String cacheName, Serializable key, Serializable obj) throws CacheManagerException {
        Element element = new Element(key, obj);
        try {
            this.getCache(cacheName).put(element);
        }
        catch (CacheException e) {
            throw new CacheManagerException((Throwable)e);
        }
    }

    public Object get(String cacheName, Serializable key) throws CacheManagerException, NotInCacheException {
        try {
            Element element = this.getCache(cacheName).get(key);
            if (element == null) {
                throw new NotInCacheException();
            }
            return element.getValue();
        }
        catch (CacheException e) {
            throw new CacheManagerException((Throwable)e);
        }
    }

    public boolean remove(String cacheName, Serializable key) throws CacheManagerException {
        return this.getCache(cacheName).remove(key);
    }

    public void removeAll(String cacheName) throws CacheManagerException {
        try {
            this.getCache(cacheName).removeAll();
        }
        catch (Exception e) {
            throw new CacheManagerException((Throwable)e);
        }
    }

    public List getAllKeys(String cacheName) throws CacheManagerException {
        List keys;
        try {
            keys = this.getCache(cacheName).getKeys();
        }
        catch (CacheException e) {
            throw new CacheManagerException("Failed to load keys from cache", (Throwable)e);
        }
        return keys;
    }

    public void afterPropertiesSet() throws Exception {
        this.configureCaches();
    }
}

