/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DirectoryCacheChangeOperations;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.TimerStack;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierMap;
import com.atlassian.crowd.embedded.impl.IdentifierSet;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.DirectoryEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.UserCreatedFromDirectorySynchronisationEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.Percentage;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbCachingRemoteChangeOperations
implements DirectoryCacheChangeOperations {
    private static final Logger logger = LoggerFactory.getLogger(DbCachingRemoteChangeOperations.class);
    private final DirectoryDao directoryDao;
    private final RemoteDirectory remoteDirectory;
    private final InternalRemoteDirectory internalDirectory;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;

    public DbCachingRemoteChangeOperations(DirectoryDao directoryDao, RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher) {
        this.directoryDao = directoryDao;
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
    }

    private Map<String, TimestampedUser> findUsersUpdatedBefore(Date date) throws OperationFailedException {
        NullRestriction restriction = date == null ? NullRestrictionImpl.INSTANCE : Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)date), Restriction.on((Property)UserTermKeys.UPDATED_DATE).lessThan((Object)date)});
        List list = this.internalDirectory.searchUsers(QueryBuilder.queryFor(TimestampedUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1));
        IdentifierMap users = new IdentifierMap(list.size());
        for (TimestampedUser timestampedUser : list) {
            users.put(timestampedUser.getName(), timestampedUser);
        }
        return users;
    }

    private Map<String, InternalDirectoryGroup> findGroupsUpdatedBefore(Date date) throws OperationFailedException {
        NullRestriction restriction = date == null ? NullRestrictionImpl.INSTANCE : Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.CREATED_DATE).lessThan((Object)date), Restriction.on((Property)GroupTermKeys.UPDATED_DATE).lessThan((Object)date)});
        List groups = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)restriction).returningAtMost(-1));
        List roles = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)restriction).returningAtMost(-1));
        IdentifierMap result = new IdentifierMap(groups.size() + roles.size());
        for (InternalDirectoryGroup internalGroup : groups) {
            result.put(internalGroup.getName(), internalGroup);
        }
        for (InternalDirectoryGroup internalGroup : roles) {
            result.put(internalGroup.getName(), internalGroup);
        }
        return result;
    }

    @Override
    public void addUsers(Set<UserTemplateWithCredentialAndAttributes> usersToAdd) throws OperationFailedException {
        if (!usersToAdd.isEmpty()) {
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.adding.users", new Serializable[]{Integer.valueOf(usersToAdd.size())});
            logger.info("adding [ {} ] users", (Object)usersToAdd.size());
            TimerStack.push();
            try {
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                BatchResult result = this.internalDirectory.addAllUsers(usersToAdd);
                for (User addedUser : result.getSuccessfulEntities()) {
                    this.publishEvent((DirectoryEvent)new UserCreatedFromDirectorySynchronisationEvent((Object)this, directory, addedUser), initialSyncHasBeenStarted);
                }
                this.logFailures(this.internalDirectory, (BatchResult<? extends DirectoryEntity>)result);
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                logger.info(TimerStack.pop("added [ " + usersToAdd.size() + " ] users in [ {0} ]"));
            }
        }
    }

    @Override
    public void updateUsers(Set<UserTemplate> usersToUpdate) throws OperationFailedException {
        if (!usersToUpdate.isEmpty()) {
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.updating.users", new Serializable[]{Integer.valueOf(usersToUpdate.size())});
            logger.info("updating [ {} ] users", (Object)usersToUpdate.size());
            TimerStack.push();
            try {
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                int count = 0;
                for (UserTemplate user : usersToUpdate) {
                    if (usersToUpdate.size() > 100 && count % 100 == 0) {
                        logger.info("updated [ {}% ] users", (Object)Percentage.get((int)count, (int)usersToUpdate.size()));
                    }
                    try {
                        User updatedUser = this.internalDirectory.updateUser(user);
                        this.publishEvent((DirectoryEvent)new UserUpdatedEvent((Object)this, directory, updatedUser), initialSyncHasBeenStarted);
                    }
                    catch (InvalidUserException e) {
                        logger.warn("Unable to synchronize user " + user.getName() + " from remote directory: " + e.getMessage(), (Throwable)e);
                    }
                    catch (UserNotFoundException e) {
                        logger.warn("Could not find user to " + user.getName() + " in internal directory: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                logger.info(TimerStack.pop("updated [ " + usersToUpdate.size() + " ] users in [ {0} ]"));
            }
        }
    }

    @Override
    public void deleteCachedUsers(Set<String> usernames) throws OperationFailedException {
        this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.deleting.users", new Serializable[]{Integer.valueOf(usernames.size())});
        logger.info("deleting [ {} ] users", (Object)usernames.size());
        TimerStack.push();
        try {
            this.internalDirectory.removeAllUsers(usernames);
            Directory directory = this.getDirectory();
            boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
            for (String deletedUser : usernames) {
                this.publishEvent((DirectoryEvent)new UserDeletedEvent((Object)this, directory, deletedUser), initialSyncHasBeenStarted);
            }
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException(e.getCause());
        }
        finally {
            logger.info(TimerStack.pop("deleted [ " + usernames.size() + " ] users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCachedUsersNotIn(List<? extends User> remoteUsers, Date synchStartDate) throws OperationFailedException {
        TimerStack.push();
        try {
            IdentifierSet remoteUsernames = new IdentifierSet(remoteUsers.size());
            HashSet<String> usersToDelete = new HashSet<String>();
            TimerStack.push();
            try {
                for (User user : remoteUsers) {
                    remoteUsernames.add(user.getName());
                }
                Map<String, TimestampedUser> users = this.findUsersUpdatedBefore(synchStartDate);
                for (TimestampedUser internalUser : users.values()) {
                    String userName = internalUser.getName();
                    if (remoteUsernames.contains(userName)) continue;
                    logger.debug("user [ {} ] not found, deleting", (Object)userName);
                    usersToDelete.add(userName);
                }
            }
            finally {
                logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for delete in DB cache in [ {0} ]"));
            }
            if (!usersToDelete.isEmpty()) {
                this.deleteCachedUsers(usersToDelete);
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned for deleted users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirectoryCacheChangeOperations.GroupsToAddUpdateReplace findGroupsToUpdate(Collection<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        HashSet<GroupTemplate> groupsToAdd = new HashSet<GroupTemplate>();
        HashSet<GroupTemplate> groupsToUpdate = new HashSet<GroupTemplate>();
        HashMap<String, GroupTemplate> groupsToReplace = new HashMap<String, GroupTemplate>();
        TimerStack.push();
        try {
            Map<String, InternalDirectoryGroup> groups = this.findGroupsUpdatedBefore(syncStartDate);
            for (Group group : remoteGroups) {
                InternalDirectoryGroup internalGroup = groups.get(group.getName());
                if (internalGroup == null) {
                    logger.debug("group [ {} ] not found, adding", (Object)group.getName());
                    groupsToAdd.add(DbCachingRemoteChangeOperations.makeGroupTemplate(group));
                    continue;
                }
                if (!group.getName().equals(internalGroup.getName())) {
                    logger.warn("remote group name [ {} ] casing differs from local group name [ {} ]. Group details will be kept updated, but the group name cannot be updated", (Object)group.getName(), (Object)internalGroup.getName());
                }
                if (internalGroup.getUpdatedDate() == null) {
                    logger.warn("group [ {} ] in directory [ {} ] has no updated date", (Object)group.getName(), (Object)this.getDirectoryId());
                } else if (syncStartDate != null && internalGroup.getUpdatedDate().getTime() > syncStartDate.getTime()) {
                    logger.debug("group [ {} ] in directory [ {} ] modified after synchronisation start, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                    continue;
                }
                if (internalGroup.isLocal()) {
                    logger.debug("group [ {} ] in directory [ {} ] matches local group of same name, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                    continue;
                }
                if (group.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP) {
                    logger.debug("role [ {} ] in directory [ {} ] matches local group of same name, skipping", (Object)group.getName(), (Object)this.getDirectoryId());
                    continue;
                }
                if (group.getType() == GroupType.GROUP && internalGroup.getType() == GroupType.LEGACY_ROLE) {
                    logger.debug("role [ {} ] in directory [ {} ] matches legacy role of same name, replacing", (Object)internalGroup.getName(), (Object)this.getDirectoryId());
                    groupsToReplace.put(internalGroup.getName(), DbCachingRemoteChangeOperations.makeGroupTemplate(group));
                    continue;
                }
                if (DbCachingRemoteChangeOperations.hasChanged(group, (Group)internalGroup)) {
                    GroupTemplate groupToUpdate = DbCachingRemoteChangeOperations.makeGroupTemplate(group);
                    groupToUpdate.setName(internalGroup.getName());
                    groupsToUpdate.add(groupToUpdate);
                    continue;
                }
                logger.trace("group [ {} ] unmodified, skipping", (Object)group.getName());
            }
            DirectoryCacheChangeOperations.GroupsToAddUpdateReplace groupsToAddUpdateReplace = new DirectoryCacheChangeOperations.GroupsToAddUpdateReplace(groupsToAdd, groupsToUpdate, groupsToReplace);
            return groupsToAddUpdateReplace;
        }
        finally {
            logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for update in DB cache in [ {0} ]"));
        }
    }

    @Override
    public void removeGroups(Collection<String> groupsToRemove) throws OperationFailedException {
        if (!groupsToRemove.isEmpty()) {
            TimerStack.push();
            try {
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                for (String entry : groupsToRemove) {
                    try {
                        this.internalDirectory.removeGroup(entry);
                        this.publishEvent((DirectoryEvent)new GroupDeletedEvent((Object)this, directory, entry), initialSyncHasBeenStarted);
                    }
                    catch (GroupNotFoundException e) {
                        logger.warn("Could not find group: " + e.getGroupName(), (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        logger.warn("Group is read-only and not allowed to be modified: " + e.getGroupName(), (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                logger.info(TimerStack.pop("deleted [ " + groupsToRemove.size() + " ] groups to be replaced [ {0} ]"));
            }
        }
    }

    @Override
    public void addGroups(Set<GroupTemplate> groupsToAdd) throws OperationFailedException {
        logger.debug("adding [ {} ] groups", (Object)groupsToAdd.size());
        if (!groupsToAdd.isEmpty()) {
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.adding.groups", new Serializable[]{Integer.valueOf(groupsToAdd.size())});
            TimerStack.push();
            try {
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                BatchResult result = this.internalDirectory.addAllGroups(groupsToAdd);
                for (Group addedGroup : result.getSuccessfulEntities()) {
                    this.publishEvent((DirectoryEvent)new GroupCreatedEvent((Object)this, directory, addedGroup), initialSyncHasBeenStarted);
                }
                this.logFailures(this.internalDirectory, (BatchResult<? extends DirectoryEntity>)result);
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                logger.info(TimerStack.pop("added [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
            }
        }
    }

    @Override
    public void updateGroups(Collection<GroupTemplate> groupsToUpdate) throws OperationFailedException {
        logger.debug("updating [ {} ] groups", (Object)groupsToUpdate.size());
        if (!groupsToUpdate.isEmpty()) {
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.updating.groups", new Serializable[]{Integer.valueOf(groupsToUpdate.size())});
            try {
                TimerStack.push();
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                for (GroupTemplate groupTemplate : groupsToUpdate) {
                    try {
                        Group updatedGroup = this.internalDirectory.updateGroup(groupTemplate);
                        this.publishEvent((DirectoryEvent)new GroupUpdatedEvent((Object)this, directory, updatedGroup), initialSyncHasBeenStarted);
                    }
                    catch (InvalidGroupException e) {
                        logger.warn("Unable to synchronise group " + groupTemplate.getName() + " with remote directory: " + e.getMessage(), (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        logger.warn("Unable to update read-only group " + groupTemplate.getName() + " with remote directory: " + e.getMessage(), (Throwable)e);
                    }
                    catch (GroupNotFoundException e) {
                        logger.warn("Unable to find group " + groupTemplate.getName() + " on update with remote directory: " + e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                logger.info(TimerStack.pop("updated [ " + groupsToUpdate.size() + " ] groups in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        HashSet<String> groupsToRemove = new HashSet<String>();
        try {
            TimerStack.push();
            IdentifierSet remoteGroupnames = new IdentifierSet(remoteGroups.size());
            for (Group group : remoteGroups) {
                remoteGroupnames.add(group.getName());
            }
            Map<String, InternalDirectoryGroup> groups = this.findGroupsUpdatedBefore(syncStartDate);
            for (InternalDirectoryGroup internalGroup : groups.values()) {
                if (internalGroup.isLocal()) continue;
                if (internalGroup.getCreatedDate() == null) {
                    logger.warn("group [ " + internalGroup.getName() + " ] in directory [ " + this.getDirectoryId() + " ] has no created date, skipping");
                } else if (syncStartDate != null && internalGroup.getCreatedDate().getTime() > syncStartDate.getTime()) {
                    logger.debug("group [ " + internalGroup.getName() + " ] created after synchronisation start, skipping");
                    continue;
                }
                if (remoteGroupnames.contains(internalGroup.getName())) continue;
                logger.debug("group [ " + internalGroup.getName() + " ] not found, deleting");
                groupsToRemove.add(internalGroup.getName());
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for delete in DB cache in [ {0} ]"));
        }
        if (!groupsToRemove.isEmpty()) {
            this.deleteCachedGroups(groupsToRemove);
        }
    }

    @Override
    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.deleting.groups", new Serializable[]{Integer.valueOf(groupnames.size())});
        logger.info("removing [ " + groupnames.size() + " ] groups");
        try {
            TimerStack.push();
            this.internalDirectory.removeAllGroups(groupnames);
            Directory directory = this.getDirectory();
            boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
            for (String groupName : groupnames) {
                this.publishEvent((DirectoryEvent)new GroupDeletedEvent((Object)this, directory, groupName), initialSyncHasBeenStarted);
            }
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            logger.info(TimerStack.pop("removed [ " + groupnames.size() + " ] groups in [ {0} ]"));
        }
    }

    private boolean hasChanged(User remoteUser, User internalUser) {
        return DbCachingRemoteChangeOperations.different(remoteUser.getFirstName(), internalUser.getFirstName()) || DbCachingRemoteChangeOperations.different(remoteUser.getLastName(), internalUser.getLastName()) || DbCachingRemoteChangeOperations.different(remoteUser.getDisplayName(), internalUser.getDisplayName()) || DbCachingRemoteChangeOperations.different(remoteUser.getEmailAddress(), internalUser.getEmailAddress()) || this.remoteDirectory.supportsInactiveAccounts() && remoteUser.isActive() != internalUser.isActive();
    }

    private static boolean hasChanged(Group remoteGroup, Group internalGroup) {
        return DbCachingRemoteChangeOperations.different(remoteGroup.getDescription(), internalGroup.getDescription());
    }

    private static boolean different(String remoteString, String internalString) {
        if (StringUtils.isEmpty((String)remoteString)) {
            return StringUtils.isNotEmpty((String)internalString);
        }
        return !InternalEntityUtils.truncateValue((String)remoteString).equals(internalString);
    }

    private static UserTemplate makeUserTemplate(User user) {
        UserTemplate template = new UserTemplate(user);
        template.setFirstName(user.getFirstName());
        template.setLastName(user.getLastName());
        template.setDisplayName(user.getDisplayName());
        template.setEmailAddress(user.getEmailAddress());
        return template;
    }

    private static GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirectoryCacheChangeOperations.AddRemoveSets<String> findUserMembershipForGroupChanges(Group group, Collection<String> remoteUsers) throws OperationFailedException {
        HashSet<String> usersToAdd = new HashSet<String>();
        HashSet<String> usersToRemove = new HashSet<String>();
        try {
            TimerStack.push();
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.user.memberships", new Serializable[]{Integer.valueOf(remoteUsers.size()), group.getName()});
            logger.debug("synchronising [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ]");
            List internalMembers = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
            logger.debug("internal directory has [ " + internalMembers.size() + " ] members");
            for (String remoteUser : remoteUsers) {
                if (internalMembers.contains(remoteUser)) continue;
                usersToAdd.add(remoteUser);
            }
            for (String internalUser : internalMembers) {
                if (remoteUsers.contains(internalUser)) continue;
                usersToRemove.add(internalUser);
            }
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemoveSets = new DirectoryCacheChangeOperations.AddRemoveSets<String>(usersToAdd, usersToRemove);
            return addRemoveSets;
        }
        finally {
            logger.debug(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
        }
    }

    @Override
    public void removeUserMembershipsForGroup(Group group, Set<String> usersToRemove) throws OperationFailedException {
        if (!usersToRemove.isEmpty()) {
            int failureCount = 0;
            try {
                TimerStack.push();
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                for (String username : usersToRemove) {
                    try {
                        this.internalDirectory.removeUserFromGroup(username, group.getName());
                        this.publishEvent((DirectoryEvent)new GroupMembershipDeletedEvent((Object)this, directory, username, group.getName(), MembershipType.GROUP_USER), initialSyncHasBeenStarted);
                    }
                    catch (UserNotFoundException e) {
                        ++failureCount;
                        logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. User was not found.", (Throwable)e);
                    }
                    catch (GroupNotFoundException e) {
                        ++failureCount;
                        logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. Group was not found.", (Throwable)e);
                    }
                    catch (MembershipNotFoundException e) {
                    }
                    catch (ReadOnlyGroupException e) {
                        ++failureCount;
                        logger.info("Could not remove user [" + username + "] from read-only group [" + group.getName() + "].", (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                int usersRemoved = usersToRemove.size() - failureCount;
                logger.info(TimerStack.pop("removed [ " + usersRemoved + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void addUserMembershipsForGroup(Group group, Set<String> usersToAdd) throws OperationFailedException {
        if (!usersToAdd.isEmpty()) {
            int usersAdded;
            Collection failedUsernames = null;
            try {
                TimerStack.push();
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                BatchResult result = this.internalDirectory.addAllUsersToGroup(usersToAdd, group.getName());
                failedUsernames = result.getFailedEntities();
                for (String username : result.getSuccessfulEntities()) {
                    this.publishEvent((DirectoryEvent)new GroupMembershipCreatedEvent((Object)this, directory, username, group.getName(), MembershipType.GROUP_USER), initialSyncHasBeenStarted);
                }
                if (!failedUsernames.isEmpty()) {
                    logger.warn("Could not add the following missing users to group [ " + group.getName() + " ]: " + failedUsernames);
                }
                usersAdded = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
            }
            catch (GroupNotFoundException e) {
                logger.warn("Could not add users to group. Group [" + group.getName() + "] was not found.", (Throwable)e);
                int usersAdded2 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                logger.info(TimerStack.pop("added [ " + usersAdded2 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
            }
            catch (DirectoryNotFoundException e2) {
                throw new OperationFailedException((Throwable)e2);
                {
                    catch (Throwable throwable) {
                        int usersAdded3 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                        logger.info(TimerStack.pop("added [ " + usersAdded3 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                        throw throwable;
                    }
                }
            }
            logger.info(TimerStack.pop("added [ " + usersAdded + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirectoryCacheChangeOperations.AddRemoveSets<String> findGroupMembershipForGroupChanges(Group parentGroup, Collection<String> remoteGroups) throws OperationFailedException {
        logger.debug("synchronising [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ]");
        HashSet<String> groupsToAdd = new HashSet<String>();
        HashSet<String> groupsToRemove = new HashSet<String>();
        try {
            TimerStack.push();
            this.synchronisationStatusManager.syncStatus(this.getDirectoryId(), "directory.caching.sync.group.memberships", new Serializable[]{Integer.valueOf(remoteGroups.size()), parentGroup.getName()});
            List internalGroups = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(parentGroup.getName()).returningAtMost(-1));
            for (String remoteGroup : remoteGroups) {
                if (internalGroups.contains(remoteGroup)) continue;
                groupsToAdd.add(remoteGroup);
            }
            for (String internalGroup : internalGroups) {
                if (remoteGroups.contains(internalGroup)) continue;
                groupsToRemove.add(internalGroup);
            }
            DirectoryCacheChangeOperations.AddRemoveSets<String> addRemoveSets = new DirectoryCacheChangeOperations.AddRemoveSets<String>(groupsToAdd, groupsToRemove);
            return addRemoveSets;
        }
        finally {
            logger.debug(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
        }
    }

    @Override
    public void addGroupMembershipsForGroup(Group parentGroup, Collection<String> groupsToAdd) throws OperationFailedException {
        if (!groupsToAdd.isEmpty()) {
            int failureCount = 0;
            try {
                TimerStack.push();
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                for (String groupname : groupsToAdd) {
                    try {
                        this.internalDirectory.addGroupToGroup(groupname, parentGroup.getName());
                        this.publishEvent((DirectoryEvent)new GroupMembershipCreatedEvent((Object)this, directory, groupname, parentGroup.getName(), MembershipType.GROUP_GROUP), initialSyncHasBeenStarted);
                    }
                    catch (GroupNotFoundException e) {
                        ++failureCount;
                        logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                    }
                    catch (InvalidMembershipException e) {
                        ++failureCount;
                        logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        ++failureCount;
                        logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. " + e.getGroupName() + " is a read-only group.", (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                int groupsAdded = groupsToAdd.size() - failureCount;
                logger.info(TimerStack.pop("added [ " + groupsAdded + " ] group members to [ " + parentGroup.getName() + " ] in [ {0} ]"));
            }
        }
    }

    @Override
    public void removeGroupMembershipsForGroup(Group parentGroup, Collection<String> groupsToRemove) throws OperationFailedException {
        if (!groupsToRemove.isEmpty()) {
            int failureCount = 0;
            try {
                TimerStack.push();
                Directory directory = this.getDirectory();
                boolean initialSyncHasBeenStarted = DbCachingRemoteChangeOperations.initialSyncHasBeenStarted(directory);
                for (String groupname : groupsToRemove) {
                    try {
                        this.internalDirectory.removeGroupFromGroup(groupname, parentGroup.getName());
                        this.publishEvent((DirectoryEvent)new GroupMembershipDeletedEvent((Object)this, directory, groupname, parentGroup.getName(), MembershipType.GROUP_GROUP), initialSyncHasBeenStarted);
                    }
                    catch (GroupNotFoundException e) {
                        ++failureCount;
                        logger.info("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                    }
                    catch (InvalidMembershipException e) {
                        ++failureCount;
                        logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                    }
                    catch (MembershipNotFoundException e) {
                        ++failureCount;
                        logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership already doesn't exist", (Throwable)e);
                    }
                    catch (ReadOnlyGroupException e) {
                        ++failureCount;
                        logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. " + e.getGroupName() + " is a read-only group.", (Throwable)e);
                    }
                }
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                int groupsRemoved = groupsToRemove.size() - failureCount;
                logger.info(TimerStack.pop("removed [ " + groupsRemoved + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
            }
        }
    }

    private static boolean initialSyncHasBeenStarted(Directory directory) {
        return directory.getValue("com.atlassian.crowd.directory.sync.issynchronising") != null;
    }

    private Directory getDirectory() throws DirectoryNotFoundException {
        return this.directoryDao.findById(this.getDirectoryId());
    }

    private long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    private void publishEvent(DirectoryEvent event, boolean initialSyncHasBeenStarted) {
        if (initialSyncHasBeenStarted) {
            this.eventPublisher.publish((Object)event);
        }
    }

    @Override
    public boolean ignoreGroupOnSynchroniseMemberships(Group remoteGroup) throws OperationFailedException {
        try {
            InternalDirectoryGroup internalGroup = this.internalDirectory.findGroupByName(remoteGroup.getName());
            return remoteGroup.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP || internalGroup.isLocal();
        }
        catch (GroupNotFoundException ex) {
            return true;
        }
    }

    @Override
    public DirectoryCacheChangeOperations.AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate> getUsersToAddAndUpdate(Collection<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        HashSet usersToAdd = Sets.newHashSet();
        HashSet usersToUpdate = Sets.newHashSet();
        int count = 0;
        Map<String, TimestampedUser> users = this.findUsersUpdatedBefore(syncStartDate);
        logger.info("scanning [ {} ] users to add or update", (Object)remoteUsers.size());
        for (User user : remoteUsers) {
            if (remoteUsers.size() > 100 && count % 100 == 0) {
                logger.info("scanned [ {}% ] users", (Object)Percentage.get((int)count, (int)remoteUsers.size()));
            }
            ++count;
            TimestampedUser internalUser = users.get(user.getName());
            if (internalUser != null) {
                if (!user.getName().equals(internalUser.getName())) {
                    logger.warn("remote username [ {} ] casing differs from local username [ {} ]. User details will be kept updated, but the username cannot be updated", (Object)user.getName(), (Object)internalUser.getName());
                }
                if (this.hasChanged(user, (User)internalUser)) {
                    UserTemplate userToUpdate = DbCachingRemoteChangeOperations.makeUserTemplate(user);
                    userToUpdate.setName(internalUser.getName());
                    if (!this.remoteDirectory.supportsInactiveAccounts()) {
                        userToUpdate.setActive(internalUser.isActive());
                    }
                    usersToUpdate.add(userToUpdate);
                    continue;
                }
                logger.trace("user [ {} ] unmodified, skipping", (Object)user.getName());
                continue;
            }
            logger.debug("user [ {} ] not found, adding", (Object)user.getName());
            usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)DbCachingRemoteChangeOperations.makeUserTemplate(user), PasswordCredential.encrypted((String)"nopass")));
        }
        return new DirectoryCacheChangeOperations.AddUpdateSets<UserTemplateWithCredentialAndAttributes, UserTemplate>(usersToAdd, usersToUpdate);
    }

    @Override
    public void addOrUpdateCachedUser(User user) throws OperationFailedException {
        UserTemplate newUser = new UserTemplate(user);
        newUser.setDirectoryId(this.getDirectoryId());
        try {
            Directory directory = this.getDirectory();
            try {
                User addedUser = this.internalDirectory.addUser(newUser, PasswordCredential.NONE);
                this.publishEvent((DirectoryEvent)new UserCreatedFromDirectorySynchronisationEvent((Object)this, directory, addedUser), true);
            }
            catch (UserAlreadyExistsException e) {
                try {
                    User updatedUser = this.internalDirectory.updateUser(newUser);
                    this.publishEvent((DirectoryEvent)new UserUpdatedEvent((Object)this, directory, updatedUser), true);
                }
                catch (UserNotFoundException unfe) {
                    logger.debug("User was deleted in the middle of the transaction", (Throwable)unfe);
                }
            }
            catch (InvalidCredentialException e) {
                throw new RuntimeException(e);
            }
        }
        catch (InvalidUserException e) {
            logger.error("Could not add or update user '" + newUser.getName() + "'", (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void deleteCachedUser(String username) throws OperationFailedException {
        try {
            this.internalDirectory.removeUser(username);
            this.publishEvent((DirectoryEvent)new UserDeletedEvent((Object)this, this.getDirectory(), username), true);
        }
        catch (UserNotFoundException e) {
            logger.debug("Deleted user does not exist locally", (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void addOrUpdateCachedGroup(Group group) throws OperationFailedException {
        GroupTemplate newGroup = new GroupTemplate(group);
        newGroup.setDirectoryId(this.getDirectoryId());
        try {
            Directory directory = this.getDirectory();
            try {
                Group updatedGroup = this.internalDirectory.updateGroup(newGroup);
                this.publishEvent((DirectoryEvent)new GroupUpdatedEvent((Object)this, directory, updatedGroup), true);
            }
            catch (GroupNotFoundException e) {
                Group addedGroup = this.internalDirectory.addGroup(newGroup);
                this.publishEvent((DirectoryEvent)new GroupCreatedEvent((Object)this, directory, addedGroup), true);
            }
            catch (ReadOnlyGroupException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        catch (InvalidGroupException e) {
            logger.error("Could not add or update group '" + newGroup.getName() + "'", (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void deleteCachedGroup(String groupName) throws OperationFailedException {
        try {
            this.internalDirectory.removeGroup(groupName);
            this.publishEvent((DirectoryEvent)new GroupDeletedEvent((Object)this, this.getDirectory(), groupName), true);
        }
        catch (GroupNotFoundException e) {
            logger.debug("Deleted group does not exist locally", (Throwable)e);
        }
        catch (ReadOnlyGroupException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void addUserToGroup(String username, String groupName) throws OperationFailedException {
        try {
            this.internalDirectory.addUserToGroup(username, groupName);
            this.publishEvent((DirectoryEvent)new GroupMembershipCreatedEvent((Object)this, this.getDirectory(), username, groupName, MembershipType.GROUP_USER), true);
        }
        catch (GroupNotFoundException e) {
            logger.debug("Cannot have membership without a group", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            logger.debug("Cannot have membership without a user", (Throwable)e);
        }
        catch (ReadOnlyGroupException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void addGroupToGroup(String childGroup, String parentGroup) throws OperationFailedException {
        try {
            this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
            this.publishEvent((DirectoryEvent)new GroupMembershipCreatedEvent((Object)this, this.getDirectory(), childGroup, parentGroup, MembershipType.GROUP_GROUP), true);
        }
        catch (GroupNotFoundException e) {
            logger.debug("Cannot have membership without a group", (Throwable)e);
        }
        catch (InvalidMembershipException e) {
            logger.debug("Later events should fix this problem", (Throwable)e);
        }
        catch (ReadOnlyGroupException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void removeUserFromGroup(String username, String groupName) throws OperationFailedException {
        try {
            this.internalDirectory.removeUserFromGroup(username, groupName);
            this.publishEvent((DirectoryEvent)new GroupMembershipDeletedEvent((Object)this, this.getDirectory(), username, groupName, MembershipType.GROUP_USER), true);
        }
        catch (MembershipNotFoundException e) {
            logger.debug("Membership has already been removed", (Throwable)e);
        }
        catch (GroupNotFoundException e) {
            logger.debug("Cannot have membership without a group", (Throwable)e);
        }
        catch (UserNotFoundException e) {
            logger.debug("Cannot have membership without a user", (Throwable)e);
        }
        catch (ReadOnlyGroupException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void removeGroupFromGroup(String childGroup, String parentGroup) throws OperationFailedException {
        try {
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
            this.publishEvent((DirectoryEvent)new GroupMembershipDeletedEvent((Object)this, this.getDirectory(), childGroup, parentGroup, MembershipType.GROUP_GROUP), true);
        }
        catch (MembershipNotFoundException e) {
            logger.debug("Membership has already been removed", (Throwable)e);
        }
        catch (GroupNotFoundException e) {
            logger.debug("Cannot have membership without a group", (Throwable)e);
        }
        catch (InvalidMembershipException e) {
            logger.debug("Later events should fix this problem", (Throwable)e);
        }
        catch (ReadOnlyGroupException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public void syncGroupMembershipsForUser(String childUsername, Set<String> parentGroupNames) throws OperationFailedException {
        Set<String> remoteParentGroupNames = this.toLowerCaseIdentifiers(parentGroupNames);
        Set<String> localParentGroupNames = this.toLowerCaseIdentifiers(this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).parentsOf(EntityDescriptor.user()).withName(childUsername).returningAtMost(-1)));
        Sets.SetView addedParentGroupNames = Sets.difference(remoteParentGroupNames, localParentGroupNames);
        for (String addedParentGroupName : addedParentGroupNames) {
            this.addUserToGroup(childUsername, addedParentGroupName);
        }
        Sets.SetView removedParentGroupNames = Sets.difference(localParentGroupNames, remoteParentGroupNames);
        for (String removedParentGroupName : removedParentGroupNames) {
            this.removeUserFromGroup(childUsername, removedParentGroupName);
        }
    }

    @Override
    public void syncGroupMembershipsAndMembersForGroup(String groupName, Set<String> parentGroupNames, Set<String> childGroupNames) throws OperationFailedException {
        Set<String> remoteParentGroupNames = this.toLowerCaseIdentifiers(parentGroupNames);
        Set<String> localParentGroupNames = this.toLowerCaseIdentifiers(this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).parentsOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(groupName).returningAtMost(-1)));
        Sets.SetView addedParentGroupNames = Sets.difference(remoteParentGroupNames, localParentGroupNames);
        for (String addedParentGroupName : addedParentGroupNames) {
            this.addGroupToGroup(groupName, addedParentGroupName);
        }
        Sets.SetView removedParentGroupNames = Sets.difference(localParentGroupNames, remoteParentGroupNames);
        for (String removedParentGroupName : removedParentGroupNames) {
            this.removeGroupFromGroup(groupName, removedParentGroupName);
        }
        Set<String> remoteChildGroupNames = this.toLowerCaseIdentifiers(childGroupNames);
        Set<String> localChildGroupNames = this.toLowerCaseIdentifiers(this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(groupName).returningAtMost(-1)));
        Sets.SetView addedChildGroupNames = Sets.difference(remoteChildGroupNames, localChildGroupNames);
        for (String addedChildGroupName : addedChildGroupNames) {
            this.addGroupToGroup(addedChildGroupName, groupName);
        }
        Sets.SetView removedChildGroupNames = Sets.difference(localChildGroupNames, remoteChildGroupNames);
        for (String removedChildGroupName : removedChildGroupNames) {
            this.removeGroupFromGroup(removedChildGroupName, groupName);
        }
    }

    private Set<String> toLowerCaseIdentifiers(Iterable<String> identifiers) {
        return ImmutableSet.copyOf((Iterable)Iterables.transform(identifiers, (Function)IdentifierUtils.TO_LOWER_CASE));
    }

    private void logFailures(InternalRemoteDirectory directory, BatchResult<? extends DirectoryEntity> result) {
        if (result.hasFailures()) {
            String directoryName = directory.getDescriptiveName();
            for (DirectoryEntity failedEntity : result.getFailedEntities()) {
                logger.warn("Could not add the following entity to the directory [ {} ]: {}", (Object)directoryName, (Object)failedEntity.getName());
            }
        }
    }
}

