/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.util.InstanceFactory;
import com.google.common.base.Preconditions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContextInstanceFactory
implements InstanceFactory,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Object getInstance(String className) throws ClassNotFoundException {
        return this.getInstance(className, this.getClass().getClassLoader());
    }

    public Object getInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return this.getInstance(ClassLoaderUtils.loadClass((String)className, (ClassLoader)classLoader));
    }

    public <T> T getInstance(Class<T> clazz) {
        return clazz.cast(this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz, 3, false));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ApplicationContext)Preconditions.checkNotNull((Object)applicationContext);
    }
}

