/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorySynchroniserHelperImpl
implements DirectorySynchroniserHelper {
    private final DirectoryDao directoryDao;

    public DirectorySynchroniserHelperImpl(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Override
    public void updateSyncStartTime(SynchronisableDirectory synchronisableDirectory) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> attributes = new HashMap<String, String>(directory.getAttributes());
        attributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", String.valueOf(System.currentTimeMillis()));
        attributes.put("com.atlassian.crowd.directory.sync.issynchronising", Boolean.TRUE.toString());
        this.updateAttributes(directory, attributes);
    }

    @Override
    public void updateSyncEndTime(SynchronisableDirectory synchronisableDirectory) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> directoryAttributes = new HashMap<String, String>(directory.getAttributes());
        String startTime = (String)directoryAttributes.get("com.atlassian.crowd.directory.sync.currentstartsynctime");
        if (startTime == null) {
            throw new IllegalStateException("Updating end time with no current start synchronisation time.");
        }
        String duration = String.valueOf(System.currentTimeMillis() - Long.parseLong(startTime));
        directoryAttributes.put("com.atlassian.crowd.directory.sync.laststartsynctime", startTime);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.lastdurationms", duration);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", null);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.issynchronising", Boolean.FALSE.toString());
        this.updateAttributes(directory, directoryAttributes);
    }

    @Override
    public boolean isSynchronising(long synchronisableDirectoryId) throws DirectoryNotFoundException {
        Directory directory = this.findDirectoryById(synchronisableDirectoryId);
        String isSynchronising = (String)directory.getAttributes().get("com.atlassian.crowd.directory.sync.issynchronising");
        return isSynchronising != null && Boolean.valueOf(isSynchronising) != false;
    }

    private void updateAttributes(Directory directory, Map<String, String> attributes) throws DirectoryNotFoundException {
        DirectoryImpl newDirectory = new DirectoryImpl(directory);
        newDirectory.setAttributes(attributes);
        this.directoryDao.update((Directory)newDirectory);
    }

    @Override
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws OperationFailedException {
        remoteDirectory.synchroniseCache(mode);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }
}

