/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.CachingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteDirectoryInstanceFactoryUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDirectoryInstanceLoader
extends CachingDirectoryInstanceLoader
implements DirectoryInstanceLoader {
    private static final Logger logger = LoggerFactory.getLogger(CustomDirectoryInstanceLoader.class);
    private final ConcurrentMap<String, Boolean> canLoadCache;
    private final InstanceFactory instanceFactory;

    public CustomDirectoryInstanceLoader(InstanceFactory instanceFactory, EventPublisher eventPublisher) {
        super(eventPublisher);
        this.instanceFactory = (InstanceFactory)Preconditions.checkNotNull((Object)instanceFactory);
        this.canLoadCache = new MapMaker().softKeys().makeComputingMap((Function)new Function<String, Boolean>(){

            public Boolean apply(String className) {
                Boolean canLoadRemoteDirectoryClass;
                try {
                    Class clazz = ClassLoaderUtils.loadClass((String)className, (ClassLoader)((Object)((Object)CustomDirectoryInstanceLoader.this)).getClass().getClassLoader());
                    canLoadRemoteDirectoryClass = RemoteDirectory.class.isAssignableFrom(clazz);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Could not load class: {}", (Object)className);
                    canLoadRemoteDirectoryClass = Boolean.FALSE;
                }
                return canLoadRemoteDirectoryClass;
            }
        });
    }

    protected RemoteDirectory getNewDirectory(Directory directory) throws DirectoryInstantiationException {
        return this.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory((InstanceFactory)this.instanceFactory, (Long)id, (String)className, attributes);
    }

    public boolean canLoad(String className) {
        return (Boolean)this.canLoadCache.get(className);
    }
}

