/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DbCachingRemoteDirectoryCache;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.TimerStack;
import com.atlassian.crowd.directory.hybrid.LocalGroupHandler;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.UsnChangedCacheRefresher;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbCachingRemoteDirectory
implements RemoteDirectory,
SynchronisableDirectory {
    private static final Logger log = Logger.getLogger(DbCachingRemoteDirectory.class);
    public static final String INTERNAL_USER_PASSWORD = "nopass";
    private final RemoteDirectory remoteDirectory;
    private final LocalGroupHandler localGroupHandler;
    private final InternalRemoteDirectory internalDirectory;
    private final CacheRefresher cacheRefresher;

    public DbCachingRemoteDirectory(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory, EventPublisher eventPublisher) {
        this.localGroupHandler = new LocalGroupHandler(internalDirectory);
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
        this.cacheRefresher = remoteDirectory instanceof MicrosoftActiveDirectory ? new UsnChangedCacheRefresher((MicrosoftActiveDirectory)remoteDirectory, eventPublisher) : new RemoteDirectoryCacheRefresher(remoteDirectory, eventPublisher);
        log.debug((Object)("DBCached directory created for directory [ " + remoteDirectory.getDirectoryId() + " ]"));
    }

    public long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    public void setDirectoryId(long directoryId) {
        throw new UnsupportedOperationException("You cannot mutate the directoryID of " + this.getClass().getName());
    }

    public String getDescriptiveName() {
        return this.remoteDirectory.getDescriptiveName();
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("You cannot mutate the attributes of " + this.getClass().getName());
    }

    public User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserByName(name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        return this.internalDirectory.findUserWithAttributesByName(name);
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        if (this.remoteDirectory instanceof RemoteCrowdDirectory) {
            return this.remoteDirectory.authenticate(name, credential);
        }
        return this.performAuthenticationAndUpdateAttributes(name, credential);
    }

    private User performAuthenticationAndUpdateAttributes(String name, PasswordCredential credential) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, OperationFailedException, InvalidAuthenticationException {
        HashMap<String, Set<String>> attributesToUpdate = new HashMap<String, Set<String>>();
        try {
            User authenticatedUser = this.remoteDirectory.authenticate(name, credential);
            if (!this.remoteDirectory.supportsInactiveAccounts()) {
                try {
                    TimestampedUser internalUser = this.internalDirectory.findUserByName(name);
                    if (!internalUser.isActive()) {
                        throw new InactiveAccountException(name);
                    }
                }
                catch (UserNotFoundException e) {
                    return authenticatedUser;
                }
            }
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(0L)));
            attributesToUpdate.put("lastAuthenticated", Collections.singleton(Long.toString(System.currentTimeMillis())));
            this.storeUserAttributes(name, attributesToUpdate);
            return authenticatedUser;
        }
        catch (InvalidAuthenticationException e) {
            UserWithAttributes user = this.findUserWithAttributesByName(name);
            long currentInvalidAttempts = NumberUtils.toLong((String)user.getValue("invalidPasswordAttempts"), (long)0L);
            attributesToUpdate.put("invalidPasswordAttempts", Collections.singleton(Long.toString(++currentInvalidAttempts)));
            this.storeUserAttributes(name, attributesToUpdate);
            throw e;
        }
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        User addedUser = this.remoteDirectory.addUser(user, credential);
        return this.internalDirectory.addUser(new UserTemplate(addedUser), PasswordCredential.encrypted((String)INTERNAL_USER_PASSWORD));
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        User updatedUser = this.remoteDirectory.updateUser(user);
        UserTemplate updatedUserTemplate = new UserTemplate(updatedUser);
        if (!this.remoteDirectory.supportsInactiveAccounts()) {
            updatedUserTemplate.setActive(user.isActive());
        }
        return this.internalDirectory.updateUser(updatedUserTemplate);
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        this.remoteDirectory.updateUserCredential(username, credential);
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException {
        throw new UnsupportedOperationException("Renaming users is not supported");
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.storeUserAttributes(username, attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        this.internalDirectory.removeUserAttributes(username, attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        try {
            this.remoteDirectory.removeUser(name);
        }
        catch (UserNotFoundException ex) {
            this.internalDirectory.removeUser(name);
            throw ex;
        }
        this.internalDirectory.removeUser(name);
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchUsers(query);
    }

    public Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupByName(name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        return this.internalDirectory.findGroupWithAttributesByName(name);
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new InvalidGroupException((Group)group, "Group already exists in the Remote Directory");
            }
            try {
                return this.localGroupHandler.createLocalGroup(this.makeGroupTemplate((Group)group));
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        Group addedGroup = this.remoteDirectory.addGroup(group);
        return this.internalDirectory.addGroup(new GroupTemplate(addedGroup));
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(group.getName())) {
                throw new ReadOnlyGroupException(group.getName());
            }
            return this.localGroupHandler.updateLocalGroup(this.makeGroupTemplate((Group)group));
        }
        Group updatedGroup = this.remoteDirectory.updateGroup(group);
        return this.internalDirectory.updateGroup(new GroupTemplate(updatedGroup));
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Renaming groups is not supported");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.storeGroupAttributes(groupName, attributes);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        this.internalDirectory.removeGroupAttributes(groupName, attributeName);
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(name)) {
                throw new ReadOnlyGroupException(name);
            }
            this.internalDirectory.removeGroup(name);
        } else {
            try {
                this.remoteDirectory.removeGroup(name);
            }
            catch (GroupNotFoundException e) {
                this.internalDirectory.removeGroup(name);
                throw e;
            }
            this.internalDirectory.removeGroup(name);
        }
    }

    private boolean isRemoteGroup(String groupName) throws OperationFailedException {
        try {
            this.remoteDirectory.findGroupByName(groupName);
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroups(query);
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        return this.internalDirectory.isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        return this.internalDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.addUserToLocalGroup(username, groupName);
        } else {
            this.remoteDirectory.addUserToGroup(username, groupName);
            this.internalDirectory.addUserToGroup(username, groupName);
        }
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            if (this.isRemoteGroup(childGroup)) {
                throw new ReadOnlyGroupException(childGroup);
            }
            this.localGroupHandler.addLocalGroupToLocalGroup(childGroup, parentGroup);
        } else {
            this.remoteDirectory.addGroupToGroup(childGroup, parentGroup);
            this.internalDirectory.addGroupToGroup(childGroup, parentGroup);
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(groupName)) {
                throw new ReadOnlyGroupException(groupName);
            }
            this.localGroupHandler.removeUserFromLocalGroup(username, groupName);
        } else {
            this.remoteDirectory.removeUserFromGroup(username, groupName);
            this.internalDirectory.removeUserFromGroup(username, groupName);
        }
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException, ReadOnlyGroupException {
        if (this.localGroupHandler.isLocalGroupsEnabled()) {
            if (this.isRemoteGroup(parentGroup)) {
                throw new ReadOnlyGroupException(parentGroup);
            }
            if (this.isRemoteGroup(childGroup)) {
                throw new ReadOnlyGroupException(childGroup);
            }
            this.localGroupHandler.removeLocalGroupFromLocalGroup(childGroup, parentGroup);
        } else {
            this.remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
            this.internalDirectory.removeGroupFromGroup(childGroup, parentGroup);
        }
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        return this.internalDirectory.searchGroupRelationships(query);
    }

    public void testConnection() throws OperationFailedException {
        this.remoteDirectory.testConnection();
    }

    public boolean supportsInactiveAccounts() {
        return this.internalDirectory.supportsInactiveAccounts();
    }

    public boolean supportsNestedGroups() {
        return this.remoteDirectory.supportsNestedGroups();
    }

    public boolean isRolesDisabled() {
        return this.remoteDirectory.isRolesDisabled();
    }

    public Set<String> getValues(String name) {
        return this.remoteDirectory.getValues(name);
    }

    public String getValue(String name) {
        return this.remoteDirectory.getValue(name);
    }

    public boolean isEmpty() {
        return this.remoteDirectory.isEmpty();
    }

    public Set<String> getKeys() {
        return this.remoteDirectory.getKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchroniseCache(SynchronisationMode mode) throws OperationFailedException {
        try {
            TimerStack.push();
            DbCachingRemoteDirectoryCache directoryCache = new DbCachingRemoteDirectoryCache(this.remoteDirectory, this.internalDirectory);
            if (mode == SynchronisationMode.INCREMENTAL && this.cacheRefresher.canSynchroniseChanges()) {
                log.info((Object)("delta synchronisation for directory [ " + this.getDirectoryId() + " ] starting"));
                this.cacheRefresher.synchroniseChanges((DirectoryCache)directoryCache);
            } else {
                log.info((Object)("full synchronisation for directory [ " + this.getDirectoryId() + " ] starting"));
                this.cacheRefresher.synchroniseAll((DirectoryCache)directoryCache);
            }
        }
        finally {
            log.info((Object)TimerStack.pop("synchronisation complete in [ {0} ]"));
        }
    }

    private GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }
}

