/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.lock.DirectoryLockManager;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final DirectoryLockManager directoryLockManager;
    private final DirectoryDao directoryDao;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;

    public DirectorySynchroniserImpl(DirectoryLockManager directoryLockManager, DirectoryDao directoryDao, DirectorySynchroniserHelper directorySynchroniserHelper) {
        this.directoryLockManager = directoryLockManager;
        this.directoryDao = directoryDao;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) {
        long directoryId = remoteDirectory.getDirectoryId();
        Directory directory = this.findDirectoryById(directoryId);
        if (!directory.isActive()) {
            log.debug("Request to synchronise directory [ {} ] is returning silently because the directory is not active.", (Object)directoryId);
            return;
        }
        log.debug("request to synchronise directory [ {} ]", (Object)directoryId);
        Lock lock = this.directoryLockManager.getLock(directoryId);
        if (lock.tryLock()) {
            try {
                long start = System.currentTimeMillis();
                this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory, start);
                this.directorySynchroniserHelper.synchronise(remoteDirectory, mode);
                long end = System.currentTimeMillis();
                this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory, end);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        if (this.findDirectoryById(directoryId) != null) {
            Lock lock = this.directoryLockManager.getLock(directoryId);
            if (lock.tryLock()) {
                lock.unlock();
                return false;
            }
            return true;
        }
        return false;
    }

    private Directory findDirectoryById(long directoryId) {
        return this.directoryDao.findById(directoryId);
    }
}

