/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorySynchroniserHelperImpl
implements DirectorySynchroniserHelper {
    private final DirectoryDao directoryDao;

    public DirectorySynchroniserHelperImpl(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Override
    public void updateSyncStartTime(SynchronisableDirectory synchronisableDirectory, long startTime) {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> attributes = new HashMap<String, String>(directory.getAttributes());
        attributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", String.valueOf(startTime));
        this.updateAttributes(directory, attributes);
    }

    @Override
    public void updateSyncEndTime(SynchronisableDirectory synchronisableDirectory, long endTime) {
        Directory directory = this.findDirectoryById(synchronisableDirectory.getDirectoryId());
        HashMap<String, String> directoryAttributes = new HashMap<String, String>(directory.getAttributes());
        String startTime = (String)directoryAttributes.get("com.atlassian.crowd.directory.sync.currentstartsynctime");
        if (startTime == null) {
            throw new IllegalStateException("Updating end time with no current start synchronisation time.");
        }
        String duration = String.valueOf(endTime - Long.parseLong(startTime));
        directoryAttributes.put("com.atlassian.crowd.directory.sync.laststartsynctime", startTime);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.lastdurationms", duration);
        directoryAttributes.put("com.atlassian.crowd.directory.sync.currentstartsynctime", null);
        this.updateAttributes(directory, directoryAttributes);
    }

    private void updateAttributes(Directory directory, Map<String, String> attributes) {
        DirectoryImpl newDirectory = new DirectoryImpl(directory);
        newDirectory.setAttributes(attributes);
        this.directoryDao.update((Directory)newDirectory);
    }

    @Override
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) {
        remoteDirectory.synchroniseCache(mode);
    }

    private Directory findDirectoryById(long directoryId) {
        return this.directoryDao.findById(directoryId);
    }
}

