/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupAttributeDeletedEvent;
import com.atlassian.crowd.event.group.GroupAttributeStoredEvent;
import com.atlassian.crowd.event.group.GroupCreatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupUpdatedEvent;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.event.user.UserAttributeDeletedEvent;
import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.event.user.UserCredentialUpdatedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.crowd.event.user.UserUpdatedEvent;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.NestedGroupsNotSupportedException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.BulkAddResult;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerManager;
import com.atlassian.crowd.manager.lock.DirectoryLockManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryManagerGeneric
implements DirectoryManager {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final DirectoryDao directoryDao;
    private final ApplicationDAO applicationDAO;
    private final EventPublisher eventPublisher;
    private final PermissionManager permissionManager;
    private final PasswordHelper passwordHelper;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private final DirectorySynchroniser directorySynchroniser;
    private final DirectoryPollerManager directoryPollerManager;
    private final DirectoryLockManager directoryLockManager;

    public DirectoryManagerGeneric(DirectoryDao directoryDao, ApplicationDAO applicationDAO, EventPublisher eventPublisher, PermissionManager permissionManager, PasswordHelper passwordHelper, DirectoryInstanceLoader directoryInstanceLoader, DirectorySynchroniser directorySynchroniser, DirectoryPollerManager directoryPollerManager, DirectoryLockManager directoryLockManager) {
        this.directoryDao = (DirectoryDao)Preconditions.checkNotNull((Object)directoryDao);
        this.applicationDAO = (ApplicationDAO)Preconditions.checkNotNull((Object)applicationDAO);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.directoryInstanceLoader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)directoryInstanceLoader);
        this.directorySynchroniser = (DirectorySynchroniser)Preconditions.checkNotNull((Object)directorySynchroniser);
        this.directoryPollerManager = (DirectoryPollerManager)Preconditions.checkNotNull((Object)directoryPollerManager);
        this.directoryLockManager = (DirectoryLockManager)Preconditions.checkNotNull((Object)directoryLockManager);
    }

    public Directory addDirectory(Directory directory) throws DirectoryInstantiationException {
        if (!this.directoryInstanceLoader.canLoad(directory.getImplementationClass())) {
            throw new IllegalArgumentException("Failed to instantiate directory with class: " + directory.getImplementationClass());
        }
        Directory addedDirectory = this.directoryDao.add(directory);
        this.eventPublisher.publish((Object)new DirectoryCreatedEvent((Object)this, directory));
        return addedDirectory;
    }

    public Directory findDirectoryById(long directoryId) {
        return this.directoryDao.findById(directoryId);
    }

    public List<Directory> findAllDirectories() {
        return this.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
    }

    public List<Directory> searchDirectories(EntityQuery query) {
        return this.directoryDao.search(query);
    }

    public Directory findDirectoryByName(String name) {
        return this.directoryDao.findByName(name);
    }

    public Directory updateDirectory(Directory directory) {
        if (directory.getId() == null) {
            throw new DirectoryNotFoundException(directory.getId());
        }
        this.findDirectoryById(directory.getId());
        Directory updatedDirectory = this.directoryDao.update(directory);
        this.eventPublisher.publish((Object)new DirectoryUpdatedEvent((Object)this, updatedDirectory));
        return updatedDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDirectory(Directory directory) throws DirectoryNotFoundException, DirectoryCurrentlySynchronisingException {
        Lock lock = this.directoryLockManager.getLock(directory.getId());
        if (lock.tryLock()) {
            try {
                this.applicationDAO.removeDirectoryMappings(directory.getId().longValue());
                this.directoryDao.remove(directory);
                this.eventPublisher.publish((Object)new DirectoryDeletedEvent((Object)this, directory));
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new DirectoryCurrentlySynchronisingException(directory.getId().longValue());
        }
    }

    public boolean isSynchronisable(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        return remoteDirectory instanceof SynchronisableDirectory;
    }

    public void synchroniseCache(long directoryId, SynchronisationMode mode) throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            this.directoryPollerManager.triggerPoll(directoryId, mode);
        }
    }

    public boolean isSynchronising(long directoryId) throws DirectoryInstantiationException {
        return this.directorySynchroniser.isSynchronising(directoryId);
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (remoteDirectory instanceof SynchronisableDirectory) {
            Directory directory = this.findDirectoryById(directoryId);
            Map attributes = directory.getAttributes();
            long lastDuration = this.toLong((String)attributes.get("com.atlassian.crowd.directory.sync.lastdurationms"));
            long currentStartSyncTime = this.toLong((String)attributes.get("com.atlassian.crowd.directory.sync.currentstartsynctime"));
            long lastStartSyncTime = this.toLong((String)attributes.get("com.atlassian.crowd.directory.sync.laststartsynctime"));
            return new DirectorySynchronisationInformation(lastStartSyncTime, lastDuration / 1000L, currentStartSyncTime);
        }
        return null;
    }

    private long toLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private RemoteDirectory getDirectoryImplementation(long directoryId) throws DirectoryInstantiationException, DirectoryNotFoundException {
        return this.directoryInstanceLoader.getDirectory(this.findDirectoryById(directoryId));
    }

    public com.atlassian.crowd.model.user.User authenticateUser(long directoryId, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException {
        return this.getDirectoryImplementation(directoryId).authenticate(username, passwordCredential);
    }

    public com.atlassian.crowd.model.user.User findUserByName(long directoryId, String username) throws OperationFailedException {
        try {
            return this.getDirectoryImplementation(directoryId).findUserByName(username);
        }
        catch (ObjectNotFoundException e) {
            throw new UserNotFoundException(username, (Throwable)e);
        }
    }

    public UserWithAttributes findUserWithAttributesByName(long directoryId, String username) throws OperationFailedException {
        try {
            return this.getDirectoryImplementation(directoryId).findUserWithAttributesByName(username);
        }
        catch (ObjectNotFoundException e) {
            throw new UserNotFoundException(username, (Throwable)e);
        }
    }

    public <T> List<T> searchUsers(long directoryId, EntityQuery<T> query) throws OperationFailedException {
        return this.getDirectoryImplementation(directoryId).searchUsers(query);
    }

    public com.atlassian.crowd.model.user.User addUser(long directoryId, UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, OperationFailedException, DirectoryPermissionException {
        try {
            this.findUserByName(directoryId, user.getName());
            throw new InvalidUserException((User)user, "User already exists");
        }
        catch (UserNotFoundException e) {
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
                com.atlassian.crowd.model.user.User createdUser = null;
                try {
                    createdUser = this.getDirectoryImplementation(directoryId).addUser(user, credential);
                }
                catch (ObjectNotFoundException onfe) {
                    throw new UserNotFoundException(user.getName(), (Throwable)onfe);
                }
                this.eventPublisher.publish((Object)new UserCreatedEvent((Object)this, directory, createdUser));
                return createdUser;
            }
            throw new DirectoryPermissionException("Directory does not allow adding of users");
        }
    }

    public com.atlassian.crowd.model.user.User updateUser(long directoryId, UserTemplate user) throws OperationFailedException, DirectoryPermissionException, InvalidUserException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            com.atlassian.crowd.model.user.User updatedUser;
            try {
                updatedUser = this.getDirectoryImplementation(directoryId).updateUser(user);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(user.getName(), (Throwable)e);
            }
            this.eventPublisher.publish((Object)new UserUpdatedEvent((Object)this, directory, updatedUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public com.atlassian.crowd.model.user.User renameUser(long directoryId, String oldUsername, String newUsername) throws OperationFailedException, DirectoryPermissionException, InvalidUserException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            com.atlassian.crowd.model.user.User updatedUser;
            try {
                updatedUser = this.getDirectoryImplementation(directoryId).renameUser(oldUsername, newUsername);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(oldUsername, (Throwable)e);
            }
            this.eventPublisher.publish((Object)new UserUpdatedEvent((Object)this, directory, updatedUser));
            return updatedUser;
        }
        throw new DirectoryPermissionException("Directory does not allow user modifications");
    }

    public void storeUserAttributes(long directoryId, String username, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException {
        com.atlassian.crowd.model.user.User updatedUser;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            try {
                this.getDirectoryImplementation(directoryId).storeUserAttributes(username, attributes);
                updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(username, (Throwable)e);
            }
        } else {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
        this.eventPublisher.publish((Object)new UserAttributeStoredEvent((Object)this, directory, updatedUser, attributes));
    }

    public void removeUserAttributes(long directoryId, String username, String attributeName) throws OperationFailedException, DirectoryPermissionException {
        com.atlassian.crowd.model.user.User updatedUser;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            try {
                this.getDirectoryImplementation(directoryId).removeUserAttributes(username, attributeName);
                updatedUser = this.getDirectoryImplementation(directoryId).findUserByName(username);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(username, (Throwable)e);
            }
        } else {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
        this.eventPublisher.publish((Object)new UserAttributeDeletedEvent((Object)this, directory, updatedUser, attributeName));
    }

    public void updateUserCredential(long directoryId, String username, PasswordCredential credential) throws OperationFailedException, DirectoryPermissionException, InvalidCredentialException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) {
            try {
                this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(username, (Throwable)e);
            }
        } else {
            throw new DirectoryPermissionException("Directory does not allow user modifications");
        }
        this.eventPublisher.publish((Object)new UserCredentialUpdatedEvent((Object)this, directory, username, credential));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetPassword(long directoryId, String username) throws OperationFailedException, InvalidEmailAddressException, DirectoryPermissionException, InvalidCredentialException {
        com.atlassian.crowd.model.user.User user;
        Directory directory = this.findDirectoryById(directoryId);
        if (!this.permissionManager.hasPermission(directory, OperationType.UPDATE_USER)) throw new DirectoryPermissionException("Directory does not allow user modifications");
        String password = this.passwordHelper.generateRandomPassword();
        PasswordCredential credential = new PasswordCredential(password);
        try {
            user = this.getDirectoryImplementation(directoryId).findUserByName(username);
        }
        catch (ObjectNotFoundException e) {
            throw new UserNotFoundException(username, (Throwable)e);
        }
        if (!StringUtils.isNotBlank((String)user.getEmailAddress())) throw new InvalidEmailAddressException("Cannot email a new password; user's email address is blank.");
        try {
            this.getDirectoryImplementation(directoryId).updateUserCredential(username, credential);
        }
        catch (ObjectNotFoundException e) {
            throw new UserNotFoundException(username, (Throwable)e);
        }
        this.eventPublisher.publish((Object)new ResetPasswordEvent((Object)this, directory, user, password));
    }

    public void removeUser(long directoryId, String username) throws DirectoryPermissionException, OperationFailedException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.DELETE_USER)) {
            try {
                this.getDirectoryImplementation(directoryId).removeUser(username);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(username, (Throwable)e);
            }
        } else {
            throw new DirectoryPermissionException("Directory does not allow user removal");
        }
        this.eventPublisher.publish((Object)new UserDeletedEvent((Object)this, directory, username));
    }

    public Group findGroupByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException {
        try {
            return this.getDirectoryImplementation(directoryId).findGroupByName(groupName);
        }
        catch (ObjectNotFoundException e) {
            throw new GroupNotFoundException(groupName, (Throwable)e);
        }
    }

    public GroupWithAttributes findGroupWithAttributesByName(long directoryId, String groupName) throws OperationFailedException, GroupNotFoundException {
        try {
            return this.getDirectoryImplementation(directoryId).findGroupWithAttributesByName(groupName);
        }
        catch (ObjectNotFoundException e) {
            throw new GroupNotFoundException(groupName, (Throwable)e);
        }
    }

    public <T> List<T> searchGroups(long directoryId, EntityQuery<T> query) throws OperationFailedException {
        return this.getDirectoryImplementation(directoryId).searchGroups(query);
    }

    public Group addGroup(long directoryId, GroupTemplate group) throws InvalidGroupException, OperationFailedException, DirectoryPermissionException, GroupNotFoundException {
        Directory directory = this.findDirectoryById(directoryId);
        try {
            this.findGroupByName(directoryId, group.getName());
            throw new InvalidGroupException((Group)group, "Group with name <" + group.getName() + "> already exists in directory <" + directory.getName() + ">");
        }
        catch (GroupNotFoundException e) {
            Group createdGroup;
            OperationType operationType = this.getCreateOperationType((Group)group);
            if (this.permissionManager.hasPermission(directory, operationType)) {
                try {
                    createdGroup = this.getDirectoryImplementation(directoryId).addGroup(group);
                }
                catch (ObjectNotFoundException onfe) {
                    throw new GroupNotFoundException(group.getName(), (Throwable)onfe);
                }
            } else {
                if (operationType.equals((Object)OperationType.CREATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow adding of groups");
                }
                throw new DirectoryPermissionException("Directory does not allow adding of roles");
            }
            this.eventPublisher.publish((Object)new GroupCreatedEvent((Object)this, directory, createdGroup));
            return createdGroup;
        }
    }

    public Group updateGroup(long directoryId, GroupTemplate group) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException {
        Group updatedGroup;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType((Group)group))) {
            try {
                updatedGroup = this.getDirectoryImplementation(directoryId).updateGroup(group);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(group.getName());
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
        return updatedGroup;
    }

    public Group renameGroup(long directoryId, String oldGroupname, String newGroupname) throws OperationFailedException, DirectoryPermissionException, InvalidGroupException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, oldGroupname)))) {
            Group updatedGroup;
            try {
                updatedGroup = this.getDirectoryImplementation(directoryId).renameGroup(oldGroupname, newGroupname);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(oldGroupname, (Throwable)e);
            }
            this.eventPublisher.publish((Object)new GroupUpdatedEvent((Object)this, directory, updatedGroup));
            return updatedGroup;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    public void storeGroupAttributes(long directoryId, String groupName, Map<String, Set<String>> attributes) throws OperationFailedException, DirectoryPermissionException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            try {
                this.getDirectoryImplementation(directoryId).storeGroupAttributes(groupName, attributes);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(groupName, (Throwable)e);
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeStoredEvent((Object)this, directory, updateGroup, attributes));
    }

    public void removeGroupAttributes(long directoryId, String groupName, String attributeName) throws OperationFailedException, DirectoryPermissionException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            try {
                this.getDirectoryImplementation(directoryId).removeGroupAttributes(groupName, attributeName);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(groupName, (Throwable)e);
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        Group updateGroup = this.findGroupByName(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupAttributeDeletedEvent((Object)this, directory, updateGroup, attributeName));
    }

    public void removeGroup(long directoryId, String groupName) throws DirectoryPermissionException, OperationFailedException {
        Group groupToDelete;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getDeleteOperationType(groupToDelete = this.findGroupByName(directoryId, groupName)))) {
            try {
                this.getDirectoryImplementation(directoryId).removeGroup(groupName);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(groupName, (Throwable)e);
            }
        } else {
            if (operationType.equals((Object)OperationType.DELETE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group removal");
            }
            throw new DirectoryPermissionException("Directory does not allow role removal");
        }
        this.applicationDAO.removeGroupMappings(directoryId, groupName);
        this.eventPublisher.publish((Object)new GroupDeletedEvent((Object)this, directory, groupName));
    }

    public boolean isUserDirectGroupMember(long directoryId, String username, String groupName) throws OperationFailedException {
        return this.getDirectoryImplementation(directoryId).isUserDirectGroupMember(username, groupName);
    }

    public boolean isGroupDirectGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            return false;
        }
        return remoteDirectory.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException {
        if (!this.isUserDirectGroupMember(directoryId, username, groupName)) {
            Group groupToUpdate;
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
                try {
                    this.getDirectoryImplementation(directoryId).addUserToGroup(username, groupName);
                }
                catch (ObjectNotFoundException e) {
                    throw new UserNotFoundException(username, (Throwable)e);
                }
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
            } else {
                if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow group modifications");
                }
                throw new DirectoryPermissionException("Directory does not allow role modifications");
            }
        }
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, NestedGroupsNotSupportedException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new NestedGroupsNotSupportedException(directoryId);
        }
        if (!this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup)) {
            Group parentGroupToUpdate;
            OperationType operationType;
            Directory directory = this.findDirectoryById(directoryId);
            if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(parentGroupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
                if (childGroup.equals(parentGroup)) {
                    throw new InvalidMembershipException("Cannot add direct circular group membership reference");
                }
                try {
                    remoteDirectory.addGroupToGroup(childGroup, parentGroup);
                }
                catch (ObjectNotFoundException e) {
                    throw new GroupNotFoundException(childGroup, (Throwable)e);
                }
                this.eventPublisher.publish((Object)new GroupMembershipCreatedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
            } else {
                if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                    throw new DirectoryPermissionException("Directory does not allow group modifications");
                }
                throw new DirectoryPermissionException("Directory does not allow role modifications");
            }
        }
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws DirectoryPermissionException, OperationFailedException, MembershipNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            try {
                this.getDirectoryImplementation(directoryId).removeUserFromGroup(username, groupName);
            }
            catch (ObjectNotFoundException e) {
                throw new UserNotFoundException(username, (Throwable)e);
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, username, groupName, MembershipType.GROUP_USER));
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws DirectoryPermissionException, OperationFailedException, InvalidMembershipException, MembershipNotFoundException {
        Group groupToUpdate;
        OperationType operationType;
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups()) {
            throw new UnsupportedOperationException("Directory with id [" + directoryId + "] does not support nested groups");
        }
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, parentGroup)))) {
            if (childGroup.equals(parentGroup)) {
                throw new InvalidMembershipException("Cannot remove direct circular group membership reference");
            }
            try {
                remoteDirectory.removeGroupFromGroup(childGroup, parentGroup);
            }
            catch (ObjectNotFoundException e) {
                throw new GroupNotFoundException(childGroup, (Throwable)e);
            }
        } else {
            if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
                throw new DirectoryPermissionException("Directory does not allow group modifications");
            }
            throw new DirectoryPermissionException("Directory does not allow role modifications");
        }
        this.eventPublisher.publish((Object)new GroupMembershipDeletedEvent((Object)this, directory, childGroup, parentGroup, MembershipType.GROUP_GROUP));
    }

    public <T> List<T> searchDirectGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException {
        RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
        if (!remoteDirectory.supportsNestedGroups() && query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            return Collections.emptyList();
        }
        if (remoteDirectory.isRolesDisabled() && (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToMatch().getGroupType() == GroupType.LEGACY_ROLE || query.getEntityToReturn().getEntityType() == Entity.GROUP && query.getEntityToReturn().getGroupType() == GroupType.LEGACY_ROLE)) {
            return Collections.emptyList();
        }
        return this.getDirectoryImplementation(directoryId).searchGroupRelationships(query);
    }

    public boolean isUserNestedGroupMember(long directoryId, String username, String groupName) throws OperationFailedException {
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isUserNestedGroupMember(directoryId, username, groupName, new HashSet<String>());
        }
        return this.isUserDirectGroupMember(directoryId, username, groupName);
    }

    private boolean isUserNestedGroupMember(long directoryId, String username, String groupName, Set<String> visitedGroups) throws OperationFailedException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(groupName.toLowerCase())) {
                return false;
            }
            isMember = this.isUserDirectGroupMember(directoryId, username, groupName);
            visitedGroups.add(groupName.toLowerCase());
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).membersOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isUserNestedGroupMember(directoryId, username, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    public boolean isGroupNestedGroupMember(long directoryId, String childGroup, String parentGroup) throws OperationFailedException {
        if (childGroup.equals(parentGroup)) {
            return false;
        }
        if (this.getDirectoryImplementation(directoryId).supportsNestedGroups()) {
            return this.isGroupNestedGroupMember(directoryId, childGroup, parentGroup, new HashSet<String>());
        }
        return this.isGroupDirectGroupMember(directoryId, childGroup, parentGroup);
    }

    private boolean isGroupNestedGroupMember(long directoryId, String childGroupName, String parentGroupName, Set<String> visitedGroups) throws OperationFailedException {
        boolean isMember;
        block2: {
            Group childGroup;
            if (visitedGroups.contains(parentGroupName.toLowerCase())) {
                return false;
            }
            isMember = this.isGroupDirectGroupMember(directoryId, childGroupName, parentGroupName);
            visitedGroups.add(parentGroupName.toLowerCase());
            if (isMember) break block2;
            List subGroups = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).membersOf(EntityDescriptor.group()).withName(parentGroupName).returningAtMost(-1));
            Iterator i$ = subGroups.iterator();
            while (i$.hasNext() && !(isMember = this.isGroupNestedGroupMember(directoryId, childGroupName, (childGroup = (Group)i$.next()).getName(), visitedGroups))) {
            }
        }
        return isMember;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> List<T> searchNestedGroupRelationships(long directoryId, MembershipQuery<T> query) throws OperationFailedException {
        List relations;
        if (!this.getDirectoryImplementation(directoryId).supportsNestedGroups()) return this.searchDirectGroupRelationships(directoryId, query);
        int totalResults = query.getStartIndex() + query.getMaxResults();
        if (query.getMaxResults() == -1) {
            totalResults = -1;
        }
        if (query.isFindMembers()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                relations = this.findNestedUserMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                relations = this.findNestedGroupMembersOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), totalResults);
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                relations = this.findNestedGroupMembershipsOfUser(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                relations = this.findNestedGroupMembershipsOfGroup(directoryId, query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), totalResults);
            }
        }
        relations = SearchResultsUtil.constrainResults(relations, (int)query.getStartIndex(), (int)query.getMaxResults());
        if (query.getReturnType() != String.class) return relations;
        return SearchResultsUtil.convertEntitiesToNames((List)relations);
    }

    private List<Group> findNestedGroupMembershipsOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        List<Group> nestedParents = this.findNestedGroupMembershipsIncludingGroups(directoryId, Arrays.asList(group), groupType, maxResults);
        nestedParents.remove(group);
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsIncludingGroups(long directoryId, List<Group> groups, GroupType groupType, int maxResults) throws OperationFailedException {
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedParents = new LinkedHashSet<Group>();
        groupsToVisit.addAll(groups);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedParents.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedParents.contains(groupToVisit)) continue;
            nestedParents.add(groupToVisit);
            List directParents = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membershipsOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directParents);
        }
        return new ArrayList<Group>(nestedParents);
    }

    private List<Group> findNestedGroupMembershipsOfUser(long directoryId, String username, GroupType groupType, int maxResults) throws OperationFailedException {
        List<Group> directGroupMemberships = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membershipsOf(EntityDescriptor.user()).withName(username).returningAtMost(maxResults));
        return this.findNestedGroupMembershipsIncludingGroups(directoryId, directGroupMemberships, groupType, maxResults);
    }

    private List<Group> findNestedGroupMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedMembers = new LinkedHashSet<Group>();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            if (nestedMembers.contains(groupToVisit)) continue;
            nestedMembers.add(groupToVisit);
            List directMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directMembers);
        }
        nestedMembers.remove(group);
        return new ArrayList<Group>(nestedMembers);
    }

    private List<com.atlassian.crowd.model.user.User> findNestedUserMembersOfGroup(long directoryId, String groupName, GroupType groupType, int maxResults) throws OperationFailedException {
        Group group;
        try {
            group = this.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
        LinkedList<Object> groupsToVisit = new LinkedList<Object>();
        LinkedHashSet<Group> nestedGroupMembers = new LinkedHashSet<Group>();
        LinkedHashSet nestedUserMembers = new LinkedHashSet();
        groupsToVisit.add(group);
        while (!(groupsToVisit.isEmpty() || maxResults != -1 && nestedUserMembers.size() >= maxResults)) {
            Group groupToVisit = (Group)groupsToVisit.remove();
            List directUserMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            nestedUserMembers.addAll(directUserMembers);
            if (nestedGroupMembers.contains(groupToVisit)) continue;
            nestedGroupMembers.add(groupToVisit);
            List directGroupMembers = this.searchDirectGroupRelationships(directoryId, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).membersOf(EntityDescriptor.group((GroupType)groupType)).withName(groupToVisit.getName()).returningAtMost(maxResults));
            groupsToVisit.addAll(directGroupMembers);
        }
        return new ArrayList<com.atlassian.crowd.model.user.User>(nestedUserMembers);
    }

    public BulkAddResult<com.atlassian.crowd.model.user.User> addAllUsers(long directoryId, Collection<UserTemplateWithCredentialAndAttributes> users, boolean overwrite) throws DirectoryPermissionException, OperationFailedException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_USER)) {
            Collection<UserTemplateWithCredentialAndAttributes> failedEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<UserTemplateWithCredentialAndAttributes> usersToAdd = new ArrayList<UserTemplateWithCredentialAndAttributes>();
            BulkAddResult result = new BulkAddResult((long)users.size(), overwrite);
            for (UserTemplateWithCredentialAndAttributes user : users) {
                try {
                    this.findUserByName(directoryId, user.getName());
                    if (overwrite) {
                        try {
                            this.logger.info((Object)("Removing existing user: " + user));
                            this.removeUser(directoryId, user.getName());
                            usersToAdd.add(user);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Could not remove user for bulk import overwrite: " + user), (Throwable)e);
                            result.addExistingEntity((Object)user);
                        }
                        continue;
                    }
                    this.logger.info((Object)("User <" + user + "> already exists in directory. Skipping over this entity."));
                    result.addExistingEntity((Object)user);
                }
                catch (UserNotFoundException e) {
                    usersToAdd.add(user);
                }
            }
            Set uniqueUsersToAdd = this.retainUniqueEntities(usersToAdd);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                failedEntities = ((InternalRemoteDirectory)remoteDirectory).addAllUsers(uniqueUsersToAdd);
            } else {
                failedEntities = new ArrayList();
                for (UserTemplateWithCredentialAndAttributes user : uniqueUsersToAdd) {
                    try {
                        remoteDirectory.addUser((UserTemplate)user, user.getCredential());
                    }
                    catch (Exception e) {
                        failedEntities.add(user);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            return result;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of users");
    }

    private <T> Set<T> retainUniqueEntities(Collection<T> entities) {
        HashSet<T> uniqueEntities = new HashSet<T>(entities.size());
        for (T entity : entities) {
            boolean added;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Going to add: " + entity));
            }
            if (added = uniqueEntities.add(entity)) continue;
            this.logger.warn((Object)("Duplicate entity. Entity is already in the set of entities to bulk add: " + entity));
        }
        return uniqueEntities;
    }

    public BulkAddResult<Group> addAllGroups(long directoryId, Collection<GroupTemplate> groups, boolean overwrite) throws DirectoryPermissionException, OperationFailedException {
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, OperationType.CREATE_GROUP)) {
            Collection<GroupTemplate> failedEntities;
            RemoteDirectory remoteDirectory = this.getDirectoryImplementation(directoryId);
            ArrayList<GroupTemplate> groupsToAdd = new ArrayList<GroupTemplate>();
            BulkAddResult result = new BulkAddResult((long)groups.size(), overwrite);
            for (GroupTemplate group : groups) {
                try {
                    this.findGroupByName(directoryId, group.getName());
                    if (overwrite) {
                        try {
                            this.logger.info((Object)("Removing existing group: " + group));
                            this.removeGroup(directoryId, group.getName());
                            groupsToAdd.add(group);
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Could not remove group for bulk import overwrite: " + group), (Throwable)e);
                            result.addExistingEntity((Object)group);
                        }
                        continue;
                    }
                    this.logger.info((Object)("Group <" + group + "> already exists in directory. Skipping over this entity."));
                    result.addExistingEntity((Object)group);
                }
                catch (GroupNotFoundException e) {
                    groupsToAdd.add(group);
                }
            }
            Set uniqueGroupsToAdd = this.retainUniqueEntities(groupsToAdd);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                failedEntities = ((InternalRemoteDirectory)remoteDirectory).addAllGroups(uniqueGroupsToAdd);
            } else {
                failedEntities = new ArrayList();
                for (GroupTemplate group : uniqueGroupsToAdd) {
                    try {
                        remoteDirectory.addGroup(group);
                    }
                    catch (Exception e) {
                        failedEntities.add(group);
                    }
                }
            }
            result.addFailedEntities(failedEntities);
            return result;
        }
        throw new DirectoryPermissionException("Directory does not allow adding of groups");
    }

    public BulkAddResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws DirectoryPermissionException, OperationFailedException {
        Group groupToUpdate;
        OperationType operationType;
        Directory directory = this.findDirectoryById(directoryId);
        if (this.permissionManager.hasPermission(directory, operationType = this.getUpdateOperationType(groupToUpdate = this.findGroupByName(directoryId, groupName)))) {
            Collection<String> failedUsers;
            RemoteDirectory remoteDirectory = this.directoryInstanceLoader.getDirectory(directory);
            Set<String> usersToAdd = this.retainUniqueEntities(userNames);
            BulkAddResult result = new BulkAddResult((long)userNames.size(), true);
            if (remoteDirectory instanceof InternalRemoteDirectory) {
                failedUsers = ((InternalRemoteDirectory)remoteDirectory).addAllUsersToGroup(usersToAdd, groupName);
            } else {
                failedUsers = new ArrayList();
                for (String username : usersToAdd) {
                    try {
                        this.addUserToGroup(directoryId, username, groupName);
                    }
                    catch (Exception e) {
                        failedUsers.add(username);
                        this.logger.error((Object)e.getMessage());
                    }
                }
            }
            result.addFailedEntities(failedUsers);
            return result;
        }
        if (operationType.equals((Object)OperationType.UPDATE_GROUP)) {
            throw new DirectoryPermissionException("Directory does not allow group modifications");
        }
        throw new DirectoryPermissionException("Directory does not allow role modifications");
    }

    private OperationType getCreateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.CREATE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.CREATE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getUpdateOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.UPDATE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.UPDATE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }

    private OperationType getDeleteOperationType(Group group) {
        switch (group.getType()) {
            case GROUP: {
                return OperationType.DELETE_GROUP;
            }
            case LEGACY_ROLE: {
                return OperationType.DELETE_ROLE;
            }
        }
        throw new UnsupportedOperationException();
    }
}

