/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.TimerStack;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.InternalEntityUtils;
import com.atlassian.crowd.util.Percentage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbCachingRemoteDirectoryCache
implements DirectoryCache {
    private static final Logger logger = LoggerFactory.getLogger(DbCachingRemoteDirectoryCache.class);
    private final RemoteDirectory remoteDirectory;
    private final InternalRemoteDirectory internalDirectory;

    public DbCachingRemoteDirectoryCache(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        this.remoteDirectory = remoteDirectory;
        this.internalDirectory = internalDirectory;
    }

    private long getDirectoryId() {
        return this.remoteDirectory.getDirectoryId();
    }

    private Map<String, TimestampedUser> findUsers(Date syncStartDate) {
        HashMap<String, TimestampedUser> users = new HashMap<String, TimestampedUser>();
        NullRestriction restriction = syncStartDate == null ? NullRestrictionImpl.INSTANCE : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{Restriction.on((Property)UserTermKeys.CREATED_DATE).lessThan((Object)syncStartDate), Restriction.on((Property)UserTermKeys.UPDATED_DATE).lessThan((Object)syncStartDate)});
        List list = this.internalDirectory.searchUsers(QueryBuilder.queryFor(TimestampedUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)restriction).returningAtMost(-1));
        for (TimestampedUser timestampedUser : list) {
            users.put(timestampedUser.getName(), timestampedUser);
        }
        return users;
    }

    private Map<String, InternalDirectoryGroup> findGroups(Date syncStartDate) {
        HashMap<String, InternalDirectoryGroup> result = new HashMap<String, InternalDirectoryGroup>();
        NullRestriction restriction = syncStartDate == null ? NullRestrictionImpl.INSTANCE : new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.CREATED_DATE).lessThan((Object)syncStartDate), Restriction.on((Property)GroupTermKeys.UPDATED_DATE).lessThan((Object)syncStartDate)});
        List groups = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)restriction).returningAtMost(-1));
        List roles = this.internalDirectory.searchGroups(QueryBuilder.queryFor(InternalDirectoryGroup.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)restriction).returningAtMost(-1));
        for (InternalDirectoryGroup internalGroup : groups) {
            result.put(internalGroup.getName(), internalGroup);
        }
        for (InternalDirectoryGroup internalGroup : roles) {
            result.put(internalGroup.getName(), internalGroup);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedUsers(List<? extends User> remoteUsers, Date syncStartDate) throws OperationFailedException {
        block24: {
            TimerStack.push();
            try {
                HashSet<UserTemplateWithCredentialAndAttributes> usersToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
                HashSet<UserTemplate> usersToUpdate = new HashSet<UserTemplate>();
                int count = 0;
                TimerStack.push();
                try {
                    Map<String, TimestampedUser> users = this.findUsers(syncStartDate);
                    logger.info("scanning [ {} ] users to add or update", (Object)remoteUsers.size());
                    for (User user : remoteUsers) {
                        if (remoteUsers.size() > 100 && count % 100 == 0) {
                            logger.info("scanned [ {}% ] users", (Object)Percentage.get((int)count, (int)remoteUsers.size()));
                        }
                        ++count;
                        TimestampedUser internalUser = users.get(user.getName());
                        if (internalUser != null) {
                            if (this.hasChanged(user, (User)internalUser)) {
                                UserTemplate userToUpdate = this.makeUserTemplate(user);
                                if (!this.remoteDirectory.supportsInactiveAccounts()) {
                                    userToUpdate.setActive(internalUser.isActive());
                                }
                                usersToUpdate.add(userToUpdate);
                                continue;
                            }
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace("user [ {} ] unmodified, skipping", (Object)user.getName());
                            continue;
                        }
                        logger.debug("user [ {} ] not found, adding", (Object)user.getName());
                        usersToAdd.add(new UserTemplateWithCredentialAndAttributes((User)this.makeUserTemplate(user), PasswordCredential.encrypted((String)"nopass")));
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for update in DB cache in [ {0} ]"));
                }
                if (!usersToAdd.isEmpty()) {
                    logger.info("adding [ {} ] users", (Object)usersToAdd.size());
                    try {
                        TimerStack.push();
                        this.internalDirectory.addAllUsers(usersToAdd);
                    }
                    finally {
                        logger.info(TimerStack.pop("added [ " + usersToAdd.size() + " ] users in [ {0} ]"));
                    }
                }
                if (usersToUpdate.isEmpty()) break block24;
                logger.info("updating [ {} ] users", (Object)usersToUpdate.size());
                try {
                    TimerStack.push();
                    count = 0;
                    for (UserTemplate user : usersToUpdate) {
                        if (usersToUpdate.size() > 100 && count % 100 == 0) {
                            logger.info("updated [ {}% ] users", (Object)Percentage.get((int)count, (int)usersToUpdate.size()));
                        }
                        try {
                            this.internalDirectory.updateUser(user);
                        }
                        catch (InvalidUserException invalidUserException) {
                            logger.warn("Unable to synchronize user " + user.getName() + " from remote directory: " + invalidUserException.getMessage(), (Throwable)invalidUserException);
                        }
                    }
                }
                finally {
                    logger.info(TimerStack.pop("updated [ " + usersToUpdate.size() + " ] users in [ {0} ]"));
                }
            }
            finally {
                logger.info(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] users in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedUsersNotIn(List<? extends User> remoteUsers, Date synchStartDate) throws OperationFailedException {
        try {
            TimerStack.push();
            HashSet<String> remoteUsernames = new HashSet<String>(remoteUsers.size());
            HashSet<String> usersToDelete = new HashSet<String>();
            try {
                TimerStack.push();
                for (User user : remoteUsers) {
                    remoteUsernames.add(user.getName());
                }
                Map<String, TimestampedUser> users = this.findUsers(synchStartDate);
                for (TimestampedUser internalUser : users.values()) {
                    String userName = internalUser.getName();
                    if (remoteUsernames.contains(userName)) continue;
                    logger.debug("user [ " + userName + " ] not found, deleting");
                    usersToDelete.add(userName);
                }
            }
            finally {
                logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] users for delete in DB cache in [ {0} ]"));
            }
            if (!usersToDelete.isEmpty()) {
                this.deleteCachedUsers(usersToDelete);
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned for deleted users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedUsers(Set<String> usernames) throws OperationFailedException {
        logger.info("deleting [ {} ] users", (Object)usernames.size());
        try {
            TimerStack.push();
            this.internalDirectory.removeAllUsers(usernames);
        }
        finally {
            logger.info(TimerStack.pop("deleted [ " + usernames.size() + " ] users in [ {0} ]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateCachedGroups(List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        block33: {
            HashSet<Object> groupsToAdd = new HashSet<Object>();
            HashSet<GroupTemplate> groupsToUpdate = new HashSet<GroupTemplate>();
            HashMap<String, GroupTemplate> groupsToReplace = new HashMap<String, GroupTemplate>();
            logger.info("scanning [ " + remoteGroups.size() + " ] groups to add or update");
            try {
                TimerStack.push();
                try {
                    TimerStack.push();
                    Map<String, InternalDirectoryGroup> groups = this.findGroups(syncStartDate);
                    for (Group group : remoteGroups) {
                        InternalDirectoryGroup internalGroup = groups.get(group.getName());
                        if (internalGroup == null) {
                            logger.debug("group [ " + group.getName() + " ] not found, adding");
                            groupsToAdd.add(this.makeGroupTemplate(group));
                            continue;
                        }
                        if (internalGroup.getUpdatedDate() == null) {
                            logger.warn("group [ " + group.getName() + " ] in directory [ " + this.getDirectoryId() + " ] has no updated date");
                        } else if (syncStartDate != null && internalGroup.getUpdatedDate().getTime() > syncStartDate.getTime()) {
                            logger.debug("group [ " + group.getName() + "] in directory [ " + this.getDirectoryId() + " ] modified after synchronisation start, skipping");
                            continue;
                        }
                        if (internalGroup.isLocal()) {
                            logger.debug("group [ " + group.getName() + "] in directory [ " + this.getDirectoryId() + " ] matches local group of same name, skipping");
                            continue;
                        }
                        if (group.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP) {
                            logger.debug("role [ " + group.getName() + "] in directory [ " + this.getDirectoryId() + " ] matches local group of same name, skipping");
                            continue;
                        }
                        if (group.getType() == GroupType.GROUP && internalGroup.getType() == GroupType.LEGACY_ROLE) {
                            logger.debug("role [ " + internalGroup.getName() + "] in directory [ " + this.getDirectoryId() + " ] matches legacy role of same name, replacing");
                            groupsToReplace.put(internalGroup.getName(), this.makeGroupTemplate(group));
                            continue;
                        }
                        if (this.hasChanged(group, (Group)internalGroup)) {
                            groupsToUpdate.add(this.makeGroupTemplate(group));
                            continue;
                        }
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("group [ " + group.getName() + "] unmodified, skipping");
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for update in DB cache in [ {0} ]"));
                }
                logger.debug("replacing [ " + groupsToReplace.size() + " ] groups");
                if (!groupsToReplace.isEmpty()) {
                    try {
                        TimerStack.push();
                        for (Map.Entry entry : groupsToReplace.entrySet()) {
                            this.internalDirectory.removeGroup((String)entry.getKey());
                            groupsToAdd.add(entry.getValue());
                        }
                    }
                    finally {
                        logger.info(TimerStack.pop("replaced [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
                    }
                }
                logger.debug("adding [ " + groupsToAdd.size() + " ] groups");
                logger.debug("updating [ " + groupsToUpdate.size() + " ] groups");
                if (!groupsToAdd.isEmpty()) {
                    try {
                        TimerStack.push();
                        this.internalDirectory.addAllGroups(groupsToAdd);
                    }
                    finally {
                        logger.info(TimerStack.pop("added [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
                    }
                }
                if (groupsToUpdate.isEmpty()) break block33;
                try {
                    TimerStack.push();
                    for (GroupTemplate groupTemplate : groupsToUpdate) {
                        try {
                            this.internalDirectory.updateGroup(groupTemplate);
                        }
                        catch (InvalidGroupException invalidGroupException) {
                            logger.warn("Unable to synchronise group " + groupTemplate.getName() + " with remote directory: " + invalidGroupException.getMessage(), (Throwable)invalidGroupException);
                        }
                    }
                }
                finally {
                    logger.info(TimerStack.pop("updated [ " + groupsToAdd.size() + " ] groups in [ {0} ]"));
                }
            }
            finally {
                logger.info(TimerStack.pop("synchronized [ " + remoteGroups.size() + " ] groups in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedGroupsNotIn(GroupType groupType, List<? extends Group> remoteGroups, Date syncStartDate) throws OperationFailedException {
        HashSet<String> groupsToRemove = new HashSet<String>();
        try {
            TimerStack.push();
            HashSet<String> remoteGroupnames = new HashSet<String>(remoteGroups.size());
            for (Group group : remoteGroups) {
                remoteGroupnames.add(group.getName());
            }
            Map<String, InternalDirectoryGroup> groups = this.findGroups(syncStartDate);
            for (InternalDirectoryGroup internalGroup : groups.values()) {
                if (internalGroup.isLocal()) continue;
                if (internalGroup.getCreatedDate() == null) {
                    logger.warn("group [ " + internalGroup.getName() + " ] in directory [ " + this.getDirectoryId() + " ] has no created date, skipping");
                } else if (syncStartDate != null && internalGroup.getCreatedDate().getTime() > syncStartDate.getTime()) {
                    logger.debug("group [ " + internalGroup.getName() + " ] created after synchronisation start, skipping");
                    continue;
                }
                if (remoteGroupnames.contains(internalGroup.getName())) continue;
                logger.debug("group [ " + internalGroup.getName() + " ] not found, deleting");
                groupsToRemove.add(internalGroup.getName());
            }
        }
        finally {
            logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] groups for delete in DB cache in [ {0} ]"));
        }
        if (!groupsToRemove.isEmpty()) {
            this.deleteCachedGroups(groupsToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCachedGroups(Set<String> groupnames) throws OperationFailedException {
        logger.info("removing [ " + groupnames.size() + " ] groups");
        try {
            TimerStack.push();
            this.internalDirectory.removeAllGroups(groupnames);
        }
        finally {
            logger.info(TimerStack.pop("removed [ " + groupnames.size() + " ] groups in [ {0} ]"));
        }
    }

    private boolean hasChanged(User remoteUser, User internalUser) {
        return this.different(remoteUser.getFirstName(), internalUser.getFirstName()) || this.different(remoteUser.getLastName(), internalUser.getLastName()) || this.different(remoteUser.getDisplayName(), internalUser.getDisplayName()) || this.different(remoteUser.getEmailAddress(), internalUser.getEmailAddress()) || this.remoteDirectory.supportsInactiveAccounts() && remoteUser.isActive() != internalUser.isActive();
    }

    private boolean hasChanged(Group remoteGroup, Group internalGroup) {
        return this.different(remoteGroup.getDescription(), internalGroup.getDescription());
    }

    private boolean different(String remoteString, String internalString) {
        if (StringUtils.isEmpty((String)remoteString)) {
            return StringUtils.isNotEmpty((String)internalString);
        }
        return !InternalEntityUtils.truncateValue((String)remoteString).equals(internalString);
    }

    private UserTemplate makeUserTemplate(User user) {
        UserTemplate template = new UserTemplate(user);
        template.setFirstName(user.getFirstName());
        template.setLastName(user.getLastName());
        template.setDisplayName(user.getDisplayName());
        template.setEmailAddress(user.getEmailAddress());
        return template;
    }

    private GroupTemplate makeGroupTemplate(Group group) {
        GroupTemplate template = new GroupTemplate(group);
        template.setDescription(group.getDescription());
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUserMembershipsForGroup(Group group, List<String> remoteUsers) throws OperationFailedException {
        block26: {
            TimerStack.push();
            try {
                if (this.ignoreGroupOnSynchroniseMemberships(group)) {
                    return;
                }
                HashSet<String> usersToAdd = new HashSet<String>();
                HashSet<String> usersToRemove = new HashSet<String>();
                try {
                    TimerStack.push();
                    logger.debug("synchronising [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ]");
                    List internalMembers = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).membersOf(EntityDescriptor.group()).withName(group.getName()).returningAtMost(-1));
                    logger.debug("internal directory has [ " + internalMembers.size() + " ] members");
                    for (String remoteUser : remoteUsers) {
                        if (internalMembers.contains(remoteUser)) continue;
                        usersToAdd.add(remoteUser);
                    }
                    for (String internalUser : internalMembers) {
                        if (remoteUsers.contains(internalUser)) continue;
                        usersToRemove.add(internalUser);
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteUsers.size() + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
                }
                logger.debug("adding [ " + usersToAdd.size() + " ] users to group [ " + group.getName() + " ]");
                logger.debug("removing [ " + usersToRemove.size() + " ] users from group [ " + group.getName() + " ]");
                if (!usersToAdd.isEmpty()) {
                    int usersAdded;
                    Collection failedUsernames = null;
                    try {
                        TimerStack.push();
                        failedUsernames = this.internalDirectory.addAllUsersToGroup(usersToAdd, group.getName());
                        if (!failedUsernames.isEmpty()) {
                            logger.warn("Could not add the following missing users to group [ " + group.getName() + " ]: " + failedUsernames);
                        }
                        usersAdded = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                    }
                    catch (GroupNotFoundException e) {
                        int usersAdded2;
                        try {
                            logger.warn("Could not add users to group. Group [" + group.getName() + "] was not found.", (Throwable)e);
                            usersAdded2 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                        }
                        catch (Throwable throwable) {
                            int usersAdded3 = failedUsernames != null ? usersToAdd.size() - failedUsernames.size() : 0;
                            logger.info(TimerStack.pop("added [ " + usersAdded3 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                            throw throwable;
                        }
                        logger.info(TimerStack.pop("added [ " + usersAdded2 + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                    }
                    logger.info(TimerStack.pop("added [ " + usersAdded + " ] user members to [ " + group.getName() + " ] in [ {0} ]"));
                }
                if (usersToRemove.isEmpty()) break block26;
                int failureCount = 0;
                try {
                    TimerStack.push();
                    for (String username : usersToRemove) {
                        try {
                            this.internalDirectory.removeUserFromGroup(username, group.getName());
                        }
                        catch (UserNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. User was not found.", (Throwable)e);
                        }
                        catch (GroupNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove user [" + username + "] from group [" + group.getName() + "]. Group was not found.", (Throwable)e);
                        }
                        catch (MembershipNotFoundException e) {}
                    }
                }
                finally {
                    int usersRemoved = usersToAdd.size() - failureCount;
                    logger.info(TimerStack.pop("removed [ " + usersRemoved + " ] user members from [ " + group.getName() + " ] in [ {0} ]"));
                }
            }
            finally {
                logger.debug(TimerStack.pop("synchronised [ " + remoteUsers.size() + " ] user members for group [ " + group.getName() + " ] in [ {0} ]"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncGroupMembershipsForGroup(Group parentGroup, List<String> remoteGroups) throws OperationFailedException {
        block27: {
            if (this.ignoreGroupOnSynchroniseMemberships(parentGroup)) {
                return;
            }
            TimerStack.push();
            try {
                logger.debug("synchronising [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ]");
                ArrayList<String> groupsToAdd = new ArrayList<String>();
                ArrayList<String> groupsToRemove = new ArrayList<String>();
                try {
                    TimerStack.push();
                    List internalGroups = this.internalDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).membersOf(EntityDescriptor.group()).withName(parentGroup.getName()).returningAtMost(-1));
                    for (String remoteGroup : remoteGroups) {
                        if (internalGroups.contains(remoteGroup)) continue;
                        groupsToAdd.add(remoteGroup);
                    }
                    for (String internalGroup : internalGroups) {
                        if (remoteGroups.contains(internalGroup)) continue;
                        groupsToRemove.add(internalGroup);
                    }
                }
                finally {
                    logger.info(TimerStack.pop("scanned and compared [ " + remoteGroups.size() + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
                }
                logger.debug("adding [ " + groupsToAdd.size() + " ] group members from group [ " + parentGroup.getName() + " ]");
                logger.debug("removing [ " + groupsToRemove.size() + " ] group members to group [ " + parentGroup.getName() + " ]");
                if (!groupsToAdd.isEmpty()) {
                    int failureCount = 0;
                    try {
                        TimerStack.push();
                        for (String groupname : groupsToAdd) {
                            try {
                                this.internalDirectory.addGroupToGroup(groupname, parentGroup.getName());
                            }
                            catch (GroupNotFoundException e) {
                                ++failureCount;
                                logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                            }
                            catch (InvalidMembershipException e) {
                                ++failureCount;
                                logger.warn("Could not add child group [" + groupname + "] to parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                            }
                        }
                    }
                    finally {
                        int groupsAdded = groupsToAdd.size() - failureCount;
                        logger.info(TimerStack.pop("added [ " + groupsAdded + " ] group members to [ " + parentGroup.getName() + " ] in [ {0} ]"));
                    }
                }
                if (groupsToRemove.isEmpty()) break block27;
                int failureCount = 0;
                try {
                    TimerStack.push();
                    for (String groupname : groupsToRemove) {
                        try {
                            this.internalDirectory.removeGroupFromGroup(groupname, parentGroup.getName());
                        }
                        catch (GroupNotFoundException e) {
                            ++failureCount;
                            logger.info("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. One or both groups was not found", (Throwable)e);
                        }
                        catch (InvalidMembershipException e) {
                            ++failureCount;
                            logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership between child and parent group is invalid", (Throwable)e);
                        }
                        catch (MembershipNotFoundException e) {
                            ++failureCount;
                            logger.warn("Could not remove child group [" + groupname + "] from parent group [" + parentGroup.getName() + "]. Membership already doesn't exist", (Throwable)e);
                        }
                    }
                }
                finally {
                    int groupsRemoved = groupsToRemove.size() - failureCount;
                    logger.info(TimerStack.pop("removed [ " + groupsRemoved + " ] group members from [ " + parentGroup.getName() + " ] in [ {0} ]"));
                }
            }
            finally {
                logger.debug(TimerStack.pop("synchronised [ " + remoteGroups.size() + " ] group members for group [ " + parentGroup.getName() + " ] in [ {0} ]"));
            }
        }
    }

    private boolean ignoreGroupOnSynchroniseMemberships(Group remoteGroup) throws OperationFailedException {
        try {
            InternalDirectoryGroup internalGroup = this.internalDirectory.findGroupByName(remoteGroup.getName());
            return remoteGroup.getType() == GroupType.LEGACY_ROLE && internalGroup.getType() == GroupType.GROUP || internalGroup.isLocal();
        }
        catch (GroupNotFoundException ex) {
            return true;
        }
    }
}

