/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteSpacePropertyService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public class RemoteSpacePropertyServiceImpl
extends AbstractRemoteService<SpacePropertyService>
implements RemoteSpacePropertyService {
    public RemoteSpacePropertyServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    @Deprecated
    public Promise<JsonSpaceProperty> create(JsonSpaceProperty newProperty) {
        WebResource resource = this.getSpacePropertyWebResource(newProperty.getSpace().getKey());
        return this.postFuture(resource, JsonSpaceProperty.class, newProperty);
    }

    @Override
    @Deprecated
    public Promise<JsonSpaceProperty> update(JsonSpaceProperty newProperty) {
        WebResource resource = this.getSpacePropertyWebResource(newProperty.getSpace().getKey()).path(newProperty.getKey());
        return this.putFuture(resource, JsonSpaceProperty.class, newProperty);
    }

    @Override
    @Deprecated
    public Promise<Void> delete(JsonSpaceProperty property) {
        WebResource resource = this.getSpacePropertyWebResource(property.getSpace().getKey()).path(property.getKey());
        return this.deleteFuture(resource);
    }

    @Override
    public CompletionStage<JsonSpaceProperty> createCompletionStage(JsonSpaceProperty newProperty) {
        WebResource resource = this.getSpacePropertyWebResource(newProperty.getSpace().getKey());
        return this.postCompletionStage(resource, JsonSpaceProperty.class, newProperty);
    }

    @Override
    public CompletionStage<JsonSpaceProperty> updateCompletionStage(JsonSpaceProperty newProperty) {
        WebResource resource = this.getSpacePropertyWebResource(newProperty.getSpace().getKey()).path(newProperty.getKey());
        return this.putCompletionStage(resource, JsonSpaceProperty.class, newProperty);
    }

    @Override
    public CompletionStage<Void> deleteCompletionStage(JsonSpaceProperty property) {
        WebResource resource = this.getSpacePropertyWebResource(property.getSpace().getKey()).path(property.getKey());
        return this.deleteCompletionStage(resource);
    }

    @Override
    public RemoteSpacePropertyService.RemoteSpacePropertyFinder find(Expansion ... expansions) {
        return new RemoteSpacePropertyFinderImpl(this, expansions);
    }

    private WebResource getSpacePropertyWebResource(String key) {
        return this.newRestWebResource().path("space").path(key).path("property");
    }

    @Override
    public RemoteSpacePropertyService.RemoteValidator validator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public class RemoteSpacePropertyFinderImpl
    extends AbstractRemoteService<SpacePropertyService.SpacePropertyFinder>
    implements RemoteSpacePropertyService.RemoteSpacePropertyFinder {
        private Expansion[] expansions;
        private String spaceKey;
        private String key;

        protected RemoteSpacePropertyFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.expansions = expansions;
        }

        @Override
        public RemoteSpacePropertyService.RemoteSpacePropertyFinder withSpaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        @Override
        public RemoteSpacePropertyService.RemoteSpacePropertyFinder withPropertyKey(String key) {
            this.key = key;
            return this;
        }

        @Override
        @Deprecated
        public Promise<PageResponse<JsonSpaceProperty>> fetchMany(PageRequest request) {
            WebResource resource = RemoteSpacePropertyServiceImpl.this.getSpacePropertyWebResource(this.spaceKey);
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getFuturePageResponseList(resource, JsonSpaceProperty.class);
        }

        @Override
        @Deprecated
        public Promise<Option<JsonSpaceProperty>> fetchOne() {
            if (this.key != null && this.spaceKey != null) {
                WebResource resource = RemoteSpacePropertyServiceImpl.this.getSpacePropertyWebResource(this.spaceKey).path(this.key);
                resource = this.addExpansions(resource, this.expansions);
                return this.getFutureOption(resource, JsonSpaceProperty.class);
            }
            throw new IllegalArgumentException("Both key and spaceKey need to be defined!");
        }

        @Override
        @Deprecated
        public Promise<JsonSpaceProperty> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }

        @Override
        public CompletionStage<PageResponse<JsonSpaceProperty>> fetchManyCompletionStage(PageRequest request) {
            WebResource resource = RemoteSpacePropertyServiceImpl.this.getSpacePropertyWebResource(this.spaceKey);
            resource = this.addExpansions(resource, this.expansions);
            resource = this.addPageRequest(resource, request);
            return this.getCompletionStagePageResponseList(resource, JsonSpaceProperty.class);
        }

        @Override
        public CompletionStage<Optional<JsonSpaceProperty>> fetchCompletionStage() {
            if (this.key != null && this.spaceKey != null) {
                WebResource resource = RemoteSpacePropertyServiceImpl.this.getSpacePropertyWebResource(this.spaceKey).path(this.key);
                resource = this.addExpansions(resource, this.expansions);
                return this.getCompletionStageOptional(resource, JsonSpaceProperty.class);
            }
            throw new IllegalArgumentException("Both key and spaceKey need to be defined!");
        }

        @Override
        public CompletionStage<JsonSpaceProperty> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }
    }
}

