/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.people.Group;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.api.service.people.PersonService;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemotePersonService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RemotePersonServiceImpl
extends AbstractRemoteService<PersonService>
implements RemotePersonService {
    public RemotePersonServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    @Deprecated
    public Promise<Person> getCurrentUser(Expansion ... expansions) {
        return this.getFuture(this.newUserResource().path("/current"), Person.class);
    }

    @Override
    public CompletionStage<Person> getCurrentUserCompletionStage(Expansion ... expansions) {
        return this.getCompletionStage(this.newUserResource().path("/current"), Person.class);
    }

    @Override
    public PersonService.Validator validator() {
        throw new NotImplementedServiceException("Remote validation is not supported");
    }

    @Override
    public RemotePersonService.RemotePersonFinder find(Expansion ... expansions) {
        return new RemotePersonFinderImpl(this, expansions);
    }

    @Override
    public LongTaskSubmission delete(Person personToDelete) {
        throw new NotImplementedServiceException("Remote user deletion is not supported");
    }

    @Override
    public RemotePersonService.RemotePersonSearcher search() {
        throw new NotImplementedServiceException("Remote search is not supported");
    }

    private WebResource newUserResource() {
        return this.newRestWebResource().path("/user");
    }

    private WebResource newGroupResource() {
        return this.newRestWebResource().path("/group");
    }

    private WebResource newUserResource(@Nullable UserKey key, @Nullable String username) {
        return this.addUserIdentifierQueryParam(this.newUserResource(), key, username);
    }

    private WebResource addUserIdentifierQueryParam(WebResource resource, @Nullable UserKey key, @Nullable String username) {
        if (key == null && username == null) {
            throw new UnsupportedOperationException("User key or username is required but both were null");
        }
        if (key != null && username != null) {
            throw new UnsupportedOperationException("Only one of key or username is required, but both were provided");
        }
        resource = key != null ? resource.queryParam("key", key.getStringValue()) : resource.queryParam("username", username);
        return resource;
    }

    public class RemotePersonFinderImpl
    extends AbstractRemoteService<PersonService.PersonFinder>
    implements RemotePersonService.RemotePersonFinder {
        private UserKey key;
        private String username;
        private Group group;
        private final Expansion[] expansions;

        protected RemotePersonFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.expansions = expansions;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withUserKey(UserKey key) {
            this.key = key;
            return this;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        public RemotePersonService.RemotePersonFinder withMembershipOf(Group group) {
            this.group = group;
            return this;
        }

        @Override
        @Deprecated
        public Promise<Option<Person>> fetchOne() {
            WebResource resource = this.addExpansions(RemotePersonServiceImpl.this.newUserResource(this.key, this.username), this.expansions);
            return this.getFutureOption(resource, Person.class);
        }

        @Override
        @Deprecated
        public Promise<Person> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }

        @Override
        @Deprecated
        public Promise<PageResponse<Person>> fetchMany(PageRequest pageRequest) {
            if (this.group == null) {
                throw new NotImplementedServiceException("Cannot bulk fetch groups without a membership query");
            }
            WebResource resource = RemotePersonServiceImpl.this.newGroupResource().path(this.group.getName()).path("member");
            resource = this.addPageRequest(resource, pageRequest);
            return this.getFuturePageResponseList(resource, Person.class);
        }

        @Override
        public CompletionStage<Optional<Person>> fetchCompletionStage() {
            WebResource resource = this.addExpansions(RemotePersonServiceImpl.this.newUserResource(this.key, this.username), this.expansions);
            return this.getCompletionStageOptional(resource, Person.class);
        }

        @Override
        public CompletionStage<Person> fetchOrNullCompletionStage() {
            return this.fetchCompletionStage().thenApplyAsync(opt -> opt.orElse(null), this.getExecutor());
        }

        @Override
        public CompletionStage<PageResponse<Person>> fetchManyCompletionStage(PageRequest pageRequest) {
            if (this.group == null) {
                throw new NotImplementedServiceException("Cannot bulk fetch groups without a membership query");
            }
            WebResource resource = RemotePersonServiceImpl.this.newGroupResource().path(this.group.getName()).path("member");
            resource = this.addPageRequest(resource, pageRequest);
            return this.getCompletionStagePageResponseList(resource, Person.class);
        }
    }
}

