/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PromisingExecutorService
implements ExecutorService {
    private final ListeningExecutorService delegate;

    public PromisingExecutorService(ListeningExecutorService service) {
        this.delegate = service;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public <T> Promise<T> submit(Callable<T> task) {
        return Promises.forListenableFuture((ListenableFuture)this.delegate.submit(task));
    }

    public <T> Promise<T> submit(Runnable task, @Nullable T result) {
        return Promises.forListenableFuture((ListenableFuture)this.delegate.submit(task, result));
    }

    public Promise<?> submit(Runnable task) {
        return Promises.forListenableFuture((ListenableFuture)this.delegate.submit(task));
    }

    <T> List<Future<T>> toListOfPromises(List<Future<T>> futures) {
        return Lists.transform(futures, input -> {
            if (input instanceof ListenableFuture) {
                return Promises.forListenableFuture((ListenableFuture)((ListenableFuture)input));
            }
            return Promises.forFuture((Future)Objects.requireNonNull(input));
        });
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.toListOfPromises(this.delegate.invokeAll(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.toListOfPromises(this.delegate.invokeAll(tasks, timeout, unit));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(command);
    }
}

