/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Label;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.SpaceStatus;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.rest.client.RemoteSingleFetcher;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import java.util.Map;

@ExperimentalApi
public interface RemoteSpaceService {
    public Promise<Space> create(Space var1, boolean var2) throws ServiceException;

    public Promise<Space> update(Space var1) throws ServiceException;

    public SpaceService.Validator validator();

    @Deprecated
    public Promise<Option<Space>> getSpace(String var1, Expansion ... var2);

    public RemoteSpaceFinder find(Expansion ... var1);

    public RemoteSpaceContentFinder findContent(Space var1, Expansion ... var2);

    public Promise<LongTaskSubmission> delete(Space var1);

    public static interface RemoteSpaceContentFinder {
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(PageRequest var1);

        public Promise<PageResponse<Content>> fetchMany(ContentType var1, PageRequest var2);

        public RemoteSpaceContentFinder withDepth(Depth var1);
    }

    public static interface RemoteSpaceSingleFetcher
    extends RemoteSingleFetcher<Space> {
    }

    public static interface RemoteSpaceFinder
    extends RemoteSpaceSingleFetcher {
        public RemoteSpaceFinder withKeys(String ... var1);

        public RemoteSpaceFinder withType(SpaceType var1);

        public RemoteSpaceFinder withStatus(SpaceStatus var1);

        public RemoteSpaceFinder withLabels(Label ... var1);

        public RemoteSpaceFinder withIsFavourited(boolean var1);

        public Promise<PageResponse<Space>> fetchMany(PageRequest var1);
    }
}

