/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Depth;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.longtasks.LongTaskSubmission;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteSpaceService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;

public class RemoteSpaceServiceImpl
extends AbstractRemoteService<SpaceService>
implements RemoteSpaceService {
    public static final String SPACE_RESOURCE_PATH = "space";
    public static final String PRIVATE_SPACE_SUBPATH = "_private";

    public RemoteSpaceServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public Promise<Space> create(Space newSpace, boolean isPrivate) throws ServiceException {
        WebResource resource = this.newSpacesRestResource();
        if (isPrivate) {
            resource = resource.path(PRIVATE_SPACE_SUBPATH);
        }
        return this.postFuture(resource, Space.class, newSpace);
    }

    @Override
    public Promise<Space> update(Space space) throws ServiceException {
        WebResource resource = this.newSpacesRestResource(space);
        return this.putFuture(resource, Space.class, space);
    }

    @Override
    public SpaceService.Validator validator() {
        throw new NotImplementedServiceException("SpaceService.validator() not yet supported");
    }

    @Override
    @Deprecated
    public Promise<Option<Space>> getSpace(String spaceKey, Expansion ... expansions) {
        throw new UnsupportedOperationException("Use find().withKeys(spaceKey).fetchOne() instead.");
    }

    @Override
    public RemoteSpaceService.RemoteSpaceFinder find(Expansion ... expansions) {
        return new RemoteSpaceFinderImpl(this, expansions);
    }

    @Override
    public RemoteSpaceService.RemoteSpaceContentFinder findContent(Space space, Expansion ... expansion) {
        return new RemoteSpaceContentFinderImpl(this, space, expansion);
    }

    @Override
    public Promise<LongTaskSubmission> delete(Space space) {
        WebResource resource = this.newSpacesRestResource(space);
        return this.deleteFuture(resource, LongTaskSubmission.class);
    }

    private WebResource newSpacesRestResource() {
        return this.newRestWebResource().path(SPACE_RESOURCE_PATH);
    }

    private WebResource newSpacesRestResource(Space space) {
        return this.newSpacesRestResource(space.getKey());
    }

    private WebResource newSpacesRestResource(String spaceKey) {
        return this.newSpacesRestResource().path(spaceKey);
    }

    public class RemoteSpaceContentFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceContentFinder>
    implements RemoteSpaceService.RemoteSpaceContentFinder {
        WebResource resource;
        private Depth depth;

        public RemoteSpaceContentFinderImpl(AbstractRemoteService other, Space space, Expansion[] expansion) {
            super(other);
            this.depth = Depth.ALL;
            this.resource = RemoteSpaceServiceImpl.this.newSpacesRestResource(space).path("content");
            this.resource = this.addExpansions(this.resource, expansion);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByType(PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource, request);
            this.resource = this.addParams();
            return this.getFutureMapOfPageResponses(this.resource, ContentType.class, Content.class);
        }

        private WebResource addParams() {
            return this.resource.queryParam("depth", this.depth.toString());
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            this.resource = this.addPageRequestParams(this.resource.path(type.getType().toLowerCase()), request);
            this.resource = this.addParams();
            return this.getFuturePageResponseList(this.resource, Content.class);
        }

        @Override
        public RemoteSpaceService.RemoteSpaceContentFinder withDepth(Depth depth) {
            this.depth = depth;
            return this;
        }
    }

    public class RemoteSpaceFinderImpl
    extends AbstractRemoteService<SpaceService.SpaceFinder>
    implements RemoteSpaceService.RemoteSpaceFinder {
        private List<String> keys;
        private final Expansion[] expansions;

        protected RemoteSpaceFinderImpl(AbstractRemoteService other, Expansion ... expansions) {
            super(other);
            this.keys = Lists.newArrayList();
            this.expansions = expansions;
        }

        @Override
        public RemoteSpaceService.RemoteSpaceFinder withKeys(String ... keys) {
            this.keys = ImmutableList.copyOf((Object[])keys);
            return this;
        }

        @Override
        public Promise<PageResponse<Space>> fetchMany(PageRequest request) {
            WebResource webResource = this.addExpansions(RemoteSpaceServiceImpl.this.newSpacesRestResource(), this.expansions);
            webResource = this.addPageRequestParams(webResource, request);
            MultivaluedMapImpl params = new MultivaluedMapImpl();
            params.put((Object)"spaceKey", this.keys);
            webResource = webResource.queryParams((MultivaluedMap)params);
            return this.getFuturePageResponseList(webResource, Space.class);
        }

        @Override
        public Promise<Option<Space>> fetchOne() {
            if (this.keys.size() == 1) {
                WebResource resource = this.addExpansions(RemoteSpaceServiceImpl.this.newSpacesRestResource(this.keys.get(0)), this.expansions);
                return this.getFutureOption(resource, Space.class);
            }
            return this.fetchMany(SimplePageRequest.ONE).map(input -> {
                if (input.size() > 0) {
                    return Option.some(input.iterator().next());
                }
                return Option.none();
            });
        }

        @Override
        public Promise<Space> fetchOneOrNull() {
            return this.fetchOne().map(Option::getOrNull);
        }
    }
}

