/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.client;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.Macro;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.locator.ContentLocator;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.exceptions.unchecked.NotImplementedServiceException;
import com.atlassian.confluence.rest.client.AbstractRemoteService;
import com.atlassian.confluence.rest.client.RemoteContentService;
import com.atlassian.confluence.rest.client.authentication.AuthenticatedWebResourceProvider;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.Promise;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nullable;
import org.joda.time.LocalDate;

public class RemoteContentServiceImpl
extends AbstractRemoteService<ContentService>
implements RemoteContentService {
    public RemoteContentServiceImpl(AuthenticatedWebResourceProvider provider, ListeningExecutorService executor) {
        super(provider, executor);
    }

    @Override
    public RemoteContentService.RemoteContentFinder find(Expansion ... expansions) {
        return new RemoteContentFinderImpl(this, expansions);
    }

    @Override
    public Future<Option<Macro>> findMacroByHash(ContentId contentId, String versionId, String hash, Expansion ... expansions) throws ServiceException {
        WebResource resource = this.newContentWebResource().path(contentId.serialise()).path("history").path(versionId).path("macro").path("hash").path(hash);
        return this.getFutureOption(resource, Macro.class);
    }

    @Override
    public Future<Content> create(Content newContent) throws ServiceException {
        WebResource resource = this.newContentWebResource();
        return this.postFuture(resource, Content.class, newContent);
    }

    @Override
    public Future<Content> update(Content content) throws ServiceException {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.putFuture(resource, Content.class, content);
    }

    @Override
    public Future<Void> delete(Content content) throws ServiceException {
        WebResource resource = this.newContentWebResource().path(content.getId().serialise());
        return this.deleteFuture(resource);
    }

    @Override
    public Future<PageResponse<Content>> getChildren(Content parent, PageRequest pageRequest, Expansion ... expansions) {
        WebResource resource = this.newRestWebResource().path("content").path(parent.getId().serialise()).path("children");
        resource = this.addExpansions(resource, expansions);
        return this.getFuturePageResponseList(resource, Content.class);
    }

    private WebResource newContentWebResource() {
        return this.newRestWebResource().path("content");
    }

    public class RemoteContentFinderImpl
    extends AbstractRemoteService<ContentService.ContentFinder>
    implements RemoteContentService.RemoteContentFinder {
        private final Expansion[] expansions;
        private ContentId contentId;
        private String spaceKey;
        private List<ContentType> contentTypes;
        private LocalDate createdDate;
        private String title;

        RemoteContentFinderImpl(RemoteContentServiceImpl otherService, Expansion ... expansions) {
            super(otherService);
            this.contentTypes = ImmutableList.of((Object)ContentType.PAGE);
            this.expansions = expansions;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        @Override
        public RemoteContentService.RemoteSingleContentFetcher withLocator(ContentLocator locator) {
            this.spaceKey = locator.getSpaceKey();
            this.createdDate = locator.getPostingDay();
            this.contentTypes = Lists.newArrayList((Object[])locator.getContentTypes());
            this.title = locator.getTitle();
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withSpace(Space ... spaces) {
            this.spaceKey = spaces.length == 1 ? spaces[0].getKey() : null;
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withType(ContentType ... types) {
            if (types.length > 0) {
                this.contentTypes = Lists.newArrayList((Object[])types);
            }
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withCreatedDate(LocalDate time) {
            this.createdDate = time;
            return this;
        }

        @Override
        public RemoteContentService.RemoteParameterContentFinder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Promise<PageResponse<Content>> fetchMany(PageRequest request) {
            WebResource webResource = RemoteContentServiceImpl.this.newContentWebResource();
            if (this.title != null) {
                webResource = webResource.queryParam("title", this.title);
            }
            if (this.spaceKey != null) {
                webResource = webResource.queryParam("spaceKey", this.spaceKey);
            }
            if (!this.contentTypes.isEmpty()) {
                webResource = webResource.queryParam("type", this.contentTypes.get(0).getType());
            }
            if (this.createdDate != null) {
                webResource = webResource.queryParam("postingDay", this.createdDate.toString("yyyy-MM-dd"));
            }
            webResource = this.addExpansions(webResource, this.expansions);
            webResource = this.addPageRequest(webResource, request);
            return this.getFuturePageResponseList(webResource, Content.class);
        }

        @Override
        public Promise<PageResponse<Content>> fetchMany(ContentType type, PageRequest request) {
            this.withType(type);
            return this.fetchMany(request);
        }

        @Override
        public Promise<Map<ContentType, PageResponse<Content>>> fetchMappedByContentType(PageRequest request) {
            throw new NotImplementedServiceException("fetchMappedByContentType not yet supported");
        }

        @Override
        public Promise<Option<Content>> fetchOne() {
            if (this.contentId != null) {
                WebResource webResource = RemoteContentServiceImpl.this.newContentWebResource().path(this.contentId.serialise());
                webResource = this.addExpansions(webResource, this.expansions);
                return this.getFutureOption(webResource, Content.class);
            }
            return this.fetchMany(SimplePageRequest.ONE).map((Function)new Function<PageResponse<Content>, Option<Content>>(){

                public Option<Content> apply(@Nullable PageResponse<Content> input) {
                    if (input.size() > 0) {
                        return Option.some(input.iterator().next());
                    }
                    return Option.none();
                }
            });
        }

        @Override
        public Promise<Content> fetchOneOrNull() {
            return this.fetchOne().map((Function)new Function<Option<Content>, Content>(){

                public Content apply(@Nullable Option<Content> input) {
                    return (Content)input.getOrNull();
                }
            });
        }
    }
}

