/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.automationservices.plugins.jenkins.appscansource;

import com.aspectsecurity.automationservices.appscansource.utilities.JenkinsExecutor;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AppScanSourceInvocation {
    private String exe;
    private String scriptFile;
    private final Map<String, String> environment = new HashMap<String, String>();

    public AppScanSourceInvocation(String exe, Run<?, ?> build, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
        this.exe = exe;
    }

    public boolean execute(JenkinsExecutor runner) throws IOException, InterruptedException {
        return runner.execute(this.buildCommandLine(), this.environment);
    }

    protected ArgumentListBuilder appendExecutable(ArgumentListBuilder args) {
        args.add(this.exe);
        return args;
    }

    public AppScanSourceInvocation addScriptFile(FilePath scriptFile) {
        this.scriptFile = scriptFile.getRemote();
        return this;
    }

    protected ArgumentListBuilder appendScript(ArgumentListBuilder args) {
        if (StringUtils.isNotBlank((String)this.scriptFile)) {
            args.add("script");
            args.add(this.scriptFile);
        }
        return args;
    }

    protected ArgumentListBuilder buildCommandLine() throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        this.appendExecutable(args);
        this.appendScript(args);
        return args;
    }
}

