/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.automationservices.plugins.jenkins.appscansource;

import com.aspectsecurity.automationservices.plugins.jenkins.appscansource.AppScanSourceCommand;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class AppScanSourceInstallation
extends ToolInstallation {
    @DataBoundConstructor
    public AppScanSourceInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public AppScanSourceInstallation forEnvironment(EnvVars environment) {
        return new AppScanSourceInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public AppScanSourceInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new AppScanSourceInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public static String getExecutable(String name, AppScanSourceCommand command, Node node, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        Jenkins j;
        if (name != null && (j = Jenkins.getInstance()) != null) {
            for (AppScanSourceInstallation tool : (AppScanSourceInstallation[])((DescriptorImpl)j.getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
                FilePath homePath;
                String home;
                if (!tool.getName().equals(name)) continue;
                if (node != null) {
                    tool = tool.forNode(node, listener);
                }
                if (env != null) {
                    tool = tool.forEnvironment(env);
                }
                if ((home = Util.fixEmpty((String)tool.getHome())) == null) continue;
                if (node != null && (homePath = node.createPath(home)) != null) {
                    return homePath.child(command.getName()).getRemote();
                }
                return home + "/" + command.getName();
            }
        }
        return command.getName();
    }

    public static AppScanSourceInstallation[] allInstallations() {
        DescriptorImpl AppScanSourceDescriptor = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        return (AppScanSourceInstallation[])AppScanSourceDescriptor.getInstallations();
    }

    public static AppScanSourceInstallation getInstallation(String AppScanSourceInstallation2) throws IOException {
        AppScanSourceInstallation[] installations = AppScanSourceInstallation.allInstallations();
        if (AppScanSourceInstallation2 == null) {
            if (installations.length == 0) {
                throw new IOException("AppScan Source not found");
            }
            return installations[0];
        }
        for (AppScanSourceInstallation installation : installations) {
            if (!AppScanSourceInstallation2.equals(installation.getName())) continue;
            return installation;
        }
        throw new IOException("AppScan Source not found");
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<AppScanSourceInstallation> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            super.configure(req, json);
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "AppScan Source";
        }
    }
}

