/*
 * Decompiled with CFR 0.152.
 */
package com.aspectsecurity.automationservices.plugins.jenkins.appscansource;

import com.aspectsecurity.automationservices.appscansource.utilities.AppScanSourceExecutor;
import com.aspectsecurity.automationservices.plugins.jenkins.appscansource.AppScanSourceInstallation;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class AppScanSourceBuilder
extends Builder
implements SimpleBuildStep {
    private final boolean disableScan;
    private final boolean acceptSSL;
    private final String customScanWorkspace;
    private String scanWorkspace;
    private final String applicationFile;
    private String installation;
    Jenkins j = Jenkins.getInstance();
    private static final String applicationFileNameValidationError = "Please point to a PAF or SLN file";
    private PrintStream logger;

    @DataBoundConstructor
    public AppScanSourceBuilder(String installation, boolean disableScan, String applicationFile, boolean acceptSSL, String customScanWorkspace) {
        this.disableScan = disableScan;
        this.applicationFile = applicationFile;
        this.installation = installation;
        this.acceptSSL = acceptSSL;
        if (customScanWorkspace == null) {
            customScanWorkspace = "";
        }
        this.customScanWorkspace = customScanWorkspace.trim();
    }

    public boolean getDisableScan() {
        return this.disableScan;
    }

    public String getCustomScanWorkspace() {
        return this.customScanWorkspace;
    }

    public boolean getAcceptSSL() {
        return this.acceptSSL;
    }

    public String getScanWorkspace() {
        return this.scanWorkspace;
    }

    public String getApplicationFile() {
        return this.applicationFile;
    }

    public String getInstallation() {
        return this.installation;
    }

    @DataBoundSetter
    public void setInstallation(String installation) {
        this.installation = installation;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Computer computer = Computer.currentComputer();
        if (computer == null) {
            throw new AbortException("The AppScan Source build step requires to be launched on a node");
        }
        this.perform(build, computer.getNode(), workspace, launcher, listener, build.getEnvironment(listener));
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull Node node, @Nonnull FilePath ws, @Nonnull Launcher launcher, @Nonnull TaskListener listener, EnvVars envVars) throws InterruptedException, IOException {
        this.logger = listener.getLogger();
        if (!this.disableScan) {
            String jenkinsJobsDir = (String)envVars.get((Object)"JENKINS_HOME") + "\\jobs";
            String defaultScanWorkspace = jenkinsJobsDir + "\\" + (String)envVars.get((Object)"JOB_NAME") + "\\builds\\" + (String)envVars.get((Object)"BUILD_NUMBER");
            this.scanWorkspace = !this.customScanWorkspace.equals("") ? this.customScanWorkspace : defaultScanWorkspace;
            boolean scanWorkspaceOk = this.checkScanWorkspace(this.scanWorkspace);
            boolean applicationFileOk = false;
            if (!AppScanSourceBuilder.checkApplicationFileName(this.applicationFile)) {
                this.logger.println(applicationFileNameValidationError);
            } else if (!this.checkApplicationFileNameExists(this.applicationFile)) {
                this.logger.println(this.applicationFile + " does not exist.");
            } else {
                applicationFileOk = true;
            }
            if (applicationFileOk && scanWorkspaceOk) {
                this.logger.println("Scanning " + this.applicationFile + " with AppScan Source");
                this.logger.println("Using Scan Workspace: " + this.scanWorkspace);
                String acceptSSLValue = "";
                if (this.acceptSSL) {
                    acceptSSLValue = "-acceptssl";
                }
                char quote = '\"';
                String cliScriptContent = "login_file " + this.getDescriptor().getASE_URL() + " " + quote + this.getDescriptor().getLoginTokenFilePath() + quote + " " + acceptSSLValue + System.lineSeparator();
                cliScriptContent = cliScriptContent + "oa " + quote + this.applicationFile + quote + System.lineSeparator();
                cliScriptContent = cliScriptContent + "sc " + quote + this.scanWorkspace + quote + System.lineSeparator();
                AppScanSourceExecutor.execute(run, ws, launcher, this.installation, node, listener, envVars, cliScriptContent);
            } else {
                this.logger.println("Please resolve issues with your application file or scan workspace configuration.");
            }
        } else {
            this.logger.println("Scan disabled in configuration. Not running scan.");
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static boolean checkApplicationFileName(String filePath) {
        return filePath.endsWith(".paf") || filePath.endsWith(".sln");
    }

    public boolean checkApplicationFileNameExists(String filePath) {
        try {
            return new FilePath(new File(filePath)).exists();
        }
        catch (IOException e) {
            this.logger.println(filePath + " could not be found. Cannot continue.");
        }
        catch (InterruptedException e) {
            this.logger.println("AppScan Source plugin thread interrupted.");
        }
        return false;
    }

    public boolean checkScanWorkspace(String jobScanWorkspace) {
        FilePath path = new FilePath(new File(jobScanWorkspace));
        try {
            if (!path.exists()) {
                this.logger.println("Scan Workspace does not exist.");
                this.logger.println(path.getRemote());
                return false;
            }
        }
        catch (IOException e) {
            this.logger.println(jobScanWorkspace + " could not be found. Cannot continue.");
        }
        catch (InterruptedException e) {
            this.logger.println("AppScan Source plugin thread interrupted.");
        }
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        String loginTokenFilePath;
        String ASE_URL;
        String installation;
        Jenkins j = Jenkins.getInstance();

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (AppScanSourceInstallation tool : AppScanSourceInstallation.allInstallations()) {
                model.add(Util.fixEmptyAndTrim((String)tool.getName()));
            }
            return model;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Run AppScan Source";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.loginTokenFilePath = formData.getString("loginTokenFilePath");
            this.ASE_URL = formData.getString("ASE_URL");
            this.save();
            return super.configure(req, formData);
        }

        public String getLoginTokenFilePath() {
            return this.loginTokenFilePath;
        }

        public String getASE_URL() {
            return this.ASE_URL;
        }

        public String getInstallation() {
            return this.installation;
        }

        public FormValidation doCheckApplicationFile(@QueryParameter String value) throws IOException, ServletException {
            if (!AppScanSourceBuilder.checkApplicationFileName(value)) {
                return FormValidation.error((String)AppScanSourceBuilder.applicationFileNameValidationError);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckInstallation(@QueryParameter String value) {
            if (AppScanSourceInstallation.allInstallations().length >= 0) {
                try {
                    if (AppScanSourceInstallation.allInstallations()[0].getName() != null) {
                        return FormValidation.ok();
                    }
                }
                catch (Exception e) {
                    return FormValidation.errorWithMarkup((String)("Please configure AppScan Source installations from <a href=\"" + this.j.getRootUrl() + "configure\" target=\"_new\">the system configuration.</a>"));
                }
            }
            return FormValidation.errorWithMarkup((String)("Please configure AppScan Source installations from <a href=\"" + this.j.getRootUrl() + "configure\" target=\"_new\">the system configuration.</a>"));
        }

        public FormValidation doCheckLoginTokenFilePath(@QueryParameter String value) throws IOException, InterruptedException {
            FilePath tokenPath = new FilePath(new File(value));
            if (!tokenPath.exists()) {
                return FormValidation.warning((String)(tokenPath.getName() + "is not a directory on the Jenkins master (but perhaps it exists on some slaves)"));
            }
            return FormValidation.ok();
        }
    }
}

