/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet.aws;

import com.amazon.jenkins.ec2fleet.Registry;
import com.amazon.jenkins.ec2fleet.fleet.AutoScalingGroupFleet;
import com.amazon.jenkins.ec2fleet.fleet.EC2Fleets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.ModifyFleetRequest;
import software.amazon.awssdk.services.ec2.model.Tag;

public class AwsPermissionChecker {
    private static final int UNAUTHORIZED_STATUS_CODE = 403;
    private String awsCrendentialsId;
    private String regionName;
    private String endpoint;

    public AwsPermissionChecker(String awsCrendentialsId, String regionName, String endpoint) {
        this.awsCrendentialsId = awsCrendentialsId;
        this.regionName = regionName;
        this.endpoint = endpoint;
    }

    public List<String> getMissingPermissions(String fleet) {
        Ec2Client ec2Client = Registry.getEc2Api().connect(this.awsCrendentialsId, this.regionName, this.endpoint);
        ArrayList<String> missingPermissions = new ArrayList<String>(this.getMissingCommonPermissions(ec2Client));
        if (StringUtils.isBlank((String)fleet)) {
            missingPermissions.addAll(this.getMissingPermissionsForEC2SpotFleet(ec2Client, fleet));
            missingPermissions.addAll(this.getMissingPermissionsForEC2EC2Fleet(ec2Client, fleet));
            missingPermissions.addAll(this.getMissingPermissionsForASG());
        } else if (EC2Fleets.isEC2SpotFleet(fleet)) {
            missingPermissions.addAll(this.getMissingPermissionsForEC2SpotFleet(ec2Client, fleet));
        } else if (EC2Fleets.isEC2EC2Fleet(fleet)) {
            missingPermissions.addAll(this.getMissingPermissionsForEC2EC2Fleet(ec2Client, fleet));
        } else {
            missingPermissions.addAll(this.getMissingPermissionsForASG());
        }
        return missingPermissions;
    }

    private List<String> getMissingPermissionsForEC2SpotFleet(Ec2Client ec2Client, String fleet) {
        ArrayList<String> missingEC2SpotFleetPermissions = new ArrayList<String>();
        if (!this.hasDescribeSpotFleetRequestsPermission(ec2Client, fleet)) {
            missingEC2SpotFleetPermissions.add(FleetAPI.DescribeSpotFleetRequests.name());
        }
        if (!this.hasDescribeSpotFleetInstancesPermission(ec2Client, fleet)) {
            missingEC2SpotFleetPermissions.add(FleetAPI.DescribeSpotFleetInstances.name());
        }
        return missingEC2SpotFleetPermissions;
    }

    private List<String> getMissingCommonPermissions(Ec2Client ec2Client) {
        ArrayList<String> missingCommonPermissions = new ArrayList<String>();
        if (!this.hasDescribeInstancePermission(ec2Client)) {
            missingCommonPermissions.add(FleetAPI.DescribeInstances.name());
        }
        if (!this.hasCreateTagsPermissions(ec2Client)) {
            missingCommonPermissions.add(FleetAPI.CreateTags.name());
        }
        if (!this.hasDescribeInstanceTypesPermission(ec2Client)) {
            missingCommonPermissions.add(FleetAPI.DescribeInstanceTypes.name());
        }
        return missingCommonPermissions;
    }

    private List<String> getMissingPermissionsForASG() {
        AutoScalingClient asgClient = new AutoScalingGroupFleet().createClient(this.awsCrendentialsId, this.regionName, this.endpoint);
        ArrayList<String> missingAsgPermissions = new ArrayList<String>();
        if (!this.hasDescribeAutoScalingGroupsPermission(asgClient)) {
            missingAsgPermissions.add(FleetAPI.DescribeAutoScalingGroups.name());
        }
        return missingAsgPermissions;
    }

    private List<String> getMissingPermissionsForEC2EC2Fleet(Ec2Client ec2Client, String fleet) {
        ArrayList<String> missingFleetPermissions = new ArrayList<String>();
        if (!this.hasDescribeEC2EC2FleetRequestsPermission(ec2Client, fleet)) {
            missingFleetPermissions.add(FleetAPI.DescribeFleets.name());
        }
        if (!this.hasDescribeEC2EC2FleetInstancesPermission(ec2Client, fleet)) {
            missingFleetPermissions.add(FleetAPI.DescribeFleetInstances.name());
        }
        if (!this.hasModifyEC2EC2FleetRequestPermission(ec2Client, fleet)) {
            missingFleetPermissions.add(FleetAPI.ModifyFleet.name());
        }
        return missingFleetPermissions;
    }

    private boolean hasModifyEC2EC2FleetRequestPermission(Ec2Client ec2Client, String fleet) {
        try {
            ec2Client.modifyFleet((ModifyFleetRequest)ModifyFleetRequest.builder().fleetId(fleet).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeEC2EC2FleetInstancesPermission(Ec2Client ec2Client, String fleet) {
        try {
            ec2Client.describeFleetInstances((DescribeFleetInstancesRequest)DescribeFleetInstancesRequest.builder().fleetId(fleet).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeEC2EC2FleetRequestsPermission(Ec2Client ec2Client, String fleet) {
        try {
            ec2Client.describeFleets((DescribeFleetsRequest)DescribeFleetsRequest.builder().fleetIds(new String[]{fleet}).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeSpotFleetInstancesPermission(Ec2Client ec2Client, String fleet) {
        try {
            ec2Client.describeSpotFleetInstances((DescribeSpotFleetInstancesRequest)DescribeSpotFleetInstancesRequest.builder().spotFleetRequestId(fleet).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeSpotFleetRequestsPermission(Ec2Client ec2Client, String fleet) {
        try {
            ec2Client.describeSpotFleetRequests((DescribeSpotFleetRequestsRequest)DescribeSpotFleetRequestsRequest.builder().spotFleetRequestIds(new String[]{fleet}).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeAutoScalingGroupsPermission(AutoScalingClient asgClient) {
        try {
            asgClient.describeAutoScalingGroups();
        }
        catch (AutoScalingException ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
        return Boolean.TRUE;
    }

    private boolean hasDescribeInstancePermission(Ec2Client ec2Client) {
        try {
            ec2Client.describeInstances((DescribeInstancesRequest)DescribeInstancesRequest.builder().dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasCreateTagsPermissions(Ec2Client ec2Client) {
        try {
            ec2Client.createTags((CreateTagsRequest)CreateTagsRequest.builder().tags(new Tag[]{(Tag)Tag.builder().key("instanceId").value("i-1234").build()}).dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    private boolean hasDescribeInstanceTypesPermission(Ec2Client ec2Client) {
        try {
            ec2Client.describeInstanceTypes((DescribeInstanceTypesRequest)DescribeInstanceTypesRequest.builder().dryRun(Boolean.valueOf(true)).build());
            return true;
        }
        catch (Ec2Exception ex) {
            return ex.awsErrorDetails().sdkHttpResponse().statusCode() != 403;
        }
    }

    public static enum FleetAPI {
        DescribeInstances,
        DescribeSpotFleetInstances,
        CreateTags,
        ModifySpotFleetRequest,
        DescribeSpotFleetRequests,
        DescribeAutoScalingGroups,
        DescribeFleets,
        DescribeFleetInstances,
        ModifyFleet,
        DescribeInstanceTypes,
        TerminateInstances,
        UpdateAutoScalingGroup;

    }
}

