/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FleetStateStats {
    @Nonnull
    private final String fleetId;
    @Nonnegative
    private int numActive;
    @Nonnegative
    private final int numDesired;
    @Nonnull
    private final State state;
    @Nonnull
    private final Set<String> instances;
    @Nonnull
    private final Map<String, Double> instanceTypeWeights;

    public FleetStateStats(@Nonnull String fleetId, int numDesired, @Nonnull State state, @Nonnull Set<String> instances, @Nonnull Map<String, Double> instanceTypeWeights) {
        this.fleetId = fleetId;
        this.numActive = instances.size();
        this.numDesired = numDesired;
        this.state = state;
        this.instances = instances;
        this.instanceTypeWeights = instanceTypeWeights;
    }

    public FleetStateStats(@Nonnull FleetStateStats stats, int numDesired) {
        this.fleetId = stats.fleetId;
        this.numActive = stats.instances.size();
        this.numDesired = numDesired;
        this.state = stats.state;
        this.instances = stats.instances;
        this.instanceTypeWeights = stats.instanceTypeWeights;
    }

    @Nonnull
    public String getFleetId() {
        return this.fleetId;
    }

    public int getNumActive() {
        return this.numActive;
    }

    public void setNumActive(int activeCount) {
        this.numActive = activeCount;
    }

    public int getNumDesired() {
        return this.numDesired;
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    @Nonnull
    public Set<String> getInstances() {
        return this.instances;
    }

    @Nonnull
    public Map<String, Double> getInstanceTypeWeights() {
        return this.instanceTypeWeights;
    }

    public static class State {
        private final String detailed;
        private final boolean active;
        private final boolean modifying;

        public static State active(String detailed) {
            return new State(true, false, detailed);
        }

        public static State modifying(String detailed) {
            return new State(true, true, detailed);
        }

        public static State active() {
            return State.active("active");
        }

        public static State notActive(String detailed) {
            return new State(false, false, detailed);
        }

        public State(boolean active, boolean modifying, String detailed) {
            this.detailed = detailed;
            this.active = active;
            this.modifying = modifying;
        }

        public boolean isModifying() {
            return this.modifying;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getDetailed() {
            return this.detailed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.active == state.active && Objects.equals(this.detailed, state.detailed);
        }

        public int hashCode() {
            return Objects.hash(this.detailed, this.active);
        }
    }
}

