/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.util;

import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import se.diabol.jenkins.workflow.api.Run;
import se.diabol.jenkins.workflow.step.TaskAction;

public final class Util {
    private Util() {
    }

    public static List<FlowNode> getTaskNodes(List<FlowNode> stageNodes) {
        ArrayList<FlowNode> result = new ArrayList<FlowNode>();
        for (int i = 0; i < stageNodes.size(); ++i) {
            FlowNode sortedNode = stageNodes.get(i);
            if (!Util.isTaskNode(sortedNode)) continue;
            result.add(sortedNode);
        }
        return result;
    }

    public static Run getRunById(List<Run> runs, int buildNumber) {
        if (runs == null || runs.isEmpty()) {
            return null;
        }
        String id = "" + buildNumber;
        for (Run run : runs) {
            if (!id.equals(run.id)) continue;
            return run;
        }
        return null;
    }

    public static <T> T head(List<T> list) {
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    private static boolean isTaskNode(FlowNode flowNode) {
        return flowNode.getAction(TaskAction.class) != null;
    }
}

