/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.workflow.model.Pipeline;

@ExportedBean(defaultVisibility=100)
public class Component
extends AbstractItem {
    private final List<Pipeline> pipelines;
    private final WorkflowJob workflowJob;

    public Component(String name, WorkflowJob job, List<Pipeline> pipelines) {
        super(name);
        this.workflowJob = job;
        this.pipelines = pipelines != null ? ImmutableList.copyOf(pipelines) : Collections.emptyList();
    }

    @Exported
    public boolean isWorkflowComponent() {
        return true;
    }

    @Exported
    public String getWorkflowUrl() {
        return this.workflowJob.getUrl();
    }

    @Exported
    public WorkflowJob getWorkflowJob() {
        return this.workflowJob;
    }

    @Exported
    public List<Pipeline> getPipelines() {
        return this.pipelines;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("pipelines", this.pipelines).toString();
    }
}

