/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.api;

import com.cloudbees.workflow.rest.external.RunExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import se.diabol.jenkins.workflow.api.Stage;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Run {
    public final Map<String, ?> _links;
    public final String id;
    public final String name;
    public final String status;
    public final DateTime startTimeMillis;
    public final DateTime endTimeMillis;
    public final Long durationMillis;
    public final List<Stage> stages;

    public Run(@JsonProperty(value="_links") Map<String, ?> _links, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="status") String status, @JsonProperty(value="startTimeMillis") DateTime startTimeMillis, @JsonProperty(value="endTimeMillis") DateTime endTimeMillis, @JsonProperty(value="durationMillis") Long durationMillis, @JsonProperty(value="stages") List<Stage> stages) {
        this._links = _links;
        this.id = id;
        this.name = name;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.durationMillis = durationMillis;
        this.stages = stages;
    }

    public Run(RunExt run) {
        this._links = new LinkedHashMap();
        this.id = run.getId();
        this.name = run.getName();
        this.status = run.getStatus().toString();
        this.startTimeMillis = new DateTime(run.getStartTimeMillis());
        this.endTimeMillis = new DateTime(run.getEndTimeMillis());
        this.durationMillis = run.getDurationMillis();
        this.stages = this.asStages(run.getStages());
    }

    public boolean hasStage(String name) {
        for (Stage stage : this.stages) {
            String stageName = stage.name;
            if (stageName == null || !stageName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Stage getStageByName(String name) {
        for (Stage stage : this.stages) {
            String stageName = stage.name;
            if (stageName == null || !stageName.equals(name)) continue;
            return stage;
        }
        return null;
    }

    private List<Stage> asStages(List<StageNodeExt> extStages) {
        ArrayList<Stage> stages = new ArrayList<Stage>(extStages.size());
        for (StageNodeExt stage : extStages) {
            stages.add(new Stage(null, stage.getId(), stage.getName(), stage.getStatus().toString(), new DateTime(stage.getStartTimeMillis()), stage.getDurationMillis()));
        }
        return stages;
    }

    public String toString() {
        return "Run{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", status='" + this.status + '\'' + '}';
    }
}

