/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.resolver;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.DependencyGraph;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.plugins.promoted_builds.JobPropertyImpl;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.tasks.BuildStep;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.DependencyDeclarer;
import se.diabol.jenkins.pipeline.RelationshipResolver;

@Extension(optional=true, ordinal=150.0)
public class PromotedBuildRelationshipResolver
extends RelationshipResolver {
    public static final Class CLASS = PromotionProcess.class;

    @Override
    public List<AbstractProject> getDownstreamProjects(AbstractProject<?, ?> project) {
        DependencyGraph graph = new DependencyGraph();
        ArrayList<AbstractProject> result = new ArrayList<AbstractProject>();
        JobPropertyImpl property = (JobPropertyImpl)project.getProperty(JobPropertyImpl.class);
        if (property != null) {
            List promotionProcesses = property.getActiveItems();
            for (PromotionProcess promotionProcess : promotionProcesses) {
                List buildSteps = promotionProcess.getBuildSteps();
                for (BuildStep buildStep : buildSteps) {
                    if (!(buildStep instanceof DependencyDeclarer)) continue;
                    ((DependencyDeclarer)buildStep).buildDependencyGraph((AbstractProject)promotionProcess, graph);
                }
                result.addAll(graph.getDownstream((AbstractProject)promotionProcess));
                for (BuildStep buildStep : buildSteps) {
                    List configs;
                    if (buildStep instanceof BuildTrigger) {
                        BuildTrigger buildTrigger = (BuildTrigger)buildStep;
                        configs = buildTrigger.getConfigs();
                        for (BuildTriggerConfig config : configs) {
                            result.addAll(config.getProjectList(project.getParent(), null));
                        }
                    }
                    if (!(buildStep instanceof TriggerBuilder)) continue;
                    TriggerBuilder triggerBuilder = (TriggerBuilder)buildStep;
                    configs = triggerBuilder.getConfigs();
                    for (BuildTriggerConfig config : configs) {
                        result.addAll(config.getProjectList(project.getParent(), null));
                    }
                }
            }
        }
        return result;
    }
}

