/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.task;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.PipelineProperty;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.results.StaticAnalysisResult;
import se.diabol.jenkins.pipeline.domain.results.TestResult;
import se.diabol.jenkins.pipeline.domain.status.SimpleStatus;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusFactory;
import se.diabol.jenkins.pipeline.domain.task.ManualStep;
import se.diabol.jenkins.pipeline.token.TokenUtils;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class Task
extends AbstractItem {
    private final String id;
    private final String link;
    private final List<TestResult> testResults;
    private final List<StaticAnalysisResult> staticAnalysisResults;
    private final Status status;
    private final ManualStep manual;
    private final String buildId;
    private final List<String> downstreamTasks;
    private final boolean initial;
    private final String description;
    private final AbstractProject project;

    public Task(AbstractProject project, String id, String name, Status status, String link, ManualStep manual, List<String> downstreamTasks, boolean initial, String description) {
        super(name);
        this.id = id;
        this.link = link;
        this.testResults = null;
        this.staticAnalysisResults = null;
        this.status = status;
        this.manual = manual;
        this.buildId = null;
        this.downstreamTasks = downstreamTasks;
        this.initial = initial;
        this.description = description;
        this.project = project;
    }

    public Task(Task task, String taskName, String buildId, Status status, String link, ManualStep manual, List<TestResult> testResults, List<StaticAnalysisResult> staticAnalysisResults, String description) {
        super(taskName);
        this.id = task.id;
        this.link = link;
        this.testResults = testResults;
        this.staticAnalysisResults = staticAnalysisResults;
        this.status = status;
        this.manual = manual;
        this.buildId = buildId;
        this.downstreamTasks = task.getDownstreamTasks();
        this.initial = task.isInitial();
        this.description = description;
        this.project = task.project;
    }

    @Exported
    public ManualStep getManualStep() {
        return this.manual;
    }

    @Exported
    public boolean isManual() {
        return this.manual != null;
    }

    @Exported
    public String getBuildId() {
        return this.buildId;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getLink() {
        return this.link;
    }

    @Exported
    public List<TestResult> getTestResults() {
        return this.testResults;
    }

    @Exported
    public List<StaticAnalysisResult> getStaticAnalysisResults() {
        return this.staticAnalysisResults;
    }

    @Exported
    public Status getStatus() {
        return this.status;
    }

    @Exported
    public List<String> getDownstreamTasks() {
        return this.downstreamTasks;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    @Exported
    public boolean isRebuildable() {
        if (this.initial) {
            return false;
        }
        if (this.status.isRunning() || this.status.isIdle() || this.status.isNotBuilt() || this.status.isQueued() || this.status.isDisabled()) {
            return false;
        }
        return this.project.hasPermission(Item.BUILD);
    }

    @Exported
    public boolean isRequiringInput() {
        return false;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public static Task getPrototypeTask(AbstractProject project, boolean initial) {
        String taskName;
        PipelineProperty property = (PipelineProperty)project.getProperty(PipelineProperty.class);
        String string = taskName = property != null && !Strings.isNullOrEmpty((String)property.getTaskName()) ? property.getTaskName() : project.getDisplayName();
        if (property == null && project.getParent() instanceof AbstractProject) {
            property = (PipelineProperty)((AbstractProject)project.getParent()).getProperty(PipelineProperty.class);
            taskName = property != null && !Strings.isNullOrEmpty((String)property.getTaskName()) ? property.getTaskName() + " " + project.getName() : project.getDisplayName();
        }
        String descriptionTemplate = property != null && !Strings.isNullOrEmpty((String)property.getDescriptionTemplate()) ? property.getDescriptionTemplate() : "";
        Status status = project.isDisabled() ? StatusFactory.disabled() : StatusFactory.idle();
        List<AbstractProject> downStreams = ProjectUtil.getDownstreamProjects(project);
        ArrayList<String> downStreamTasks = new ArrayList<String>();
        for (AbstractProject downstreamProject : downStreams) {
            downStreamTasks.add(downstreamProject.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()));
        }
        return new Task(project, project.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), taskName, status, project.getUrl(), ManualStep.resolveManualStep(project), downStreamTasks, initial, descriptionTemplate);
    }

    public Task getLatestTask(ItemGroup context, AbstractBuild firstBuild) {
        AbstractProject project = this.getProject(this, context);
        AbstractBuild build = null;
        if (!ProjectUtil.isQueued(project, firstBuild)) {
            build = BuildUtil.match((RunList<? extends AbstractBuild>)project.getBuilds(), firstBuild);
        }
        Status taskStatus = SimpleStatus.resolveStatus(project, build, firstBuild);
        ManualStep manualStep = ManualStep.getManualStepLatest(project, build, firstBuild);
        return new Task(this, this.resolveTaskName(project, this.getExpandedName(build)), this.resolveBuildId(taskStatus, build), taskStatus, this.resolveTaskLink(taskStatus, build), manualStep, TestResult.getResults(build), StaticAnalysisResult.getResults(build), this.getBuildDescription(build));
    }

    public Task getAggregatedTask(AbstractBuild versionBuild, ItemGroup context) {
        AbstractProject taskProject = this.getProject(this, context);
        AbstractBuild build = BuildUtil.match((RunList<? extends AbstractBuild>)taskProject.getBuilds(), versionBuild);
        Status taskStatus = SimpleStatus.resolveStatus(taskProject, build, null);
        ManualStep manualStep = this.getManualStep();
        return new Task(this, this.resolveTaskName(this.project, this.getExpandedName(build)), this.resolveBuildId(taskStatus, build), taskStatus, this.resolveTaskLink(taskStatus, build), manualStep, TestResult.getResults(build), StaticAnalysisResult.getResults(build), this.getBuildDescription(build));
    }

    private String getBuildDescription(AbstractBuild<?, ?> build) {
        return TokenUtils.decodedTemplate(build, this.resolveBuildDescription(build));
    }

    private String resolveTaskName(AbstractProject<?, ?> project, String name) {
        return TokenUtils.stringIsNotEmpty(name) ? name : project.getDisplayName();
    }

    private String getExpandedName(AbstractBuild<?, ?> build) {
        return TokenUtils.decodedTemplate(build, this.getName());
    }

    private String resolveTaskLink(Status taskStatus, AbstractBuild build) {
        String taskLink = this.getLink();
        if (build != null && !taskStatus.isIdle() && !taskStatus.isQueued()) {
            taskLink = taskStatus.isRunning() ? build.getUrl() + "console" : build.getUrl();
        }
        return taskLink;
    }

    private String resolveBuildId(Status taskStatus, AbstractBuild build) {
        String taskBuildId = null;
        if (build != null && !taskStatus.isIdle() && !taskStatus.isQueued()) {
            taskBuildId = String.valueOf(build.getNumber());
        }
        return taskBuildId;
    }

    private String resolveBuildDescription(AbstractBuild build) {
        String buildDescription = this.getDescription();
        if (Strings.isNullOrEmpty((String)buildDescription) && build != null) {
            buildDescription = build.getDescription();
        }
        return buildDescription;
    }

    private AbstractProject getProject(Task task, ItemGroup context) {
        return ProjectUtil.getProject(task.getId(), context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("link", (Object)this.link).add("testResults", this.testResults).add("staticAnalysisResults", this.staticAnalysisResults).add("status", (Object)this.status).add("manual", (Object)this.manual).add("buildId", (Object)this.buildId).add("downstreamTasks", this.downstreamTasks).toString();
    }
}

