/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain.results;

import hudson.model.AbstractBuild;
import hudson.tasks.test.AbstractTestResultAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.results.Result;

public class TestResult
extends Result {
    private int failed;
    private int skipped;
    private int total;

    public TestResult(String name, String url, int failed, int skipped, int total) {
        super(name, url);
        this.failed = failed;
        this.skipped = skipped;
        this.total = total;
    }

    @Exported
    public int getFailed() {
        return this.failed;
    }

    @Exported
    public int getSkipped() {
        return this.skipped;
    }

    @Exported
    public int getTotal() {
        return this.total;
    }

    public static List<TestResult> getResults(AbstractBuild<?, ?> build) {
        if (build != null) {
            ArrayList<TestResult> result = new ArrayList<TestResult>();
            AbstractTestResultAction resultAction = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
            if (resultAction != null) {
                result.add(new TestResult(resultAction.getDisplayName(), build.getUrl() + resultAction.getUrlName(), resultAction.getFailCount(), resultAction.getSkipCount(), resultAction.getTotalCount()));
            }
            return result;
        }
        return Collections.emptyList();
    }
}

