/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.util.RunList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jgrapht.DirectedGraph;
import org.jgrapht.EdgeFactory;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import se.diabol.jenkins.pipeline.PipelineProperty;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.Edge;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.StageEdgeFactory;
import se.diabol.jenkins.pipeline.domain.task.Task;
import se.diabol.jenkins.pipeline.util.BuildUtil;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

@ExportedBean(defaultVisibility=100)
public class Stage
extends AbstractItem {
    private final List<Task> tasks;
    private String version;
    private int row;
    private int column;
    private Map<String, List<String>> taskConnections;
    private List<String> downstreamStages;
    private List<Long> downstreamStageIds;
    private final long id;
    private Set<Change> changes = new HashSet<Change>();

    public Stage(String name, List<Task> tasks) {
        super(name);
        this.tasks = ImmutableList.copyOf(tasks);
        this.id = PipelineUtils.getRandom();
    }

    private Stage(Stage stage, List<Task> tasks, String version, long id) {
        this(stage.getName(), tasks, stage.getDownstreamStages(), stage.getDownstreamStageIds(), stage.getTaskConnections(), version, stage.getRow(), stage.getColumn(), id);
    }

    private Stage(String name, List<Task> tasks, List<String> downstreamStages, List<Long> downstreamStageIds, Map<String, List<String>> taskConnections, String version, int row, int column, long id) {
        super(name);
        this.tasks = tasks;
        this.version = version;
        this.row = row;
        this.column = column;
        this.downstreamStages = downstreamStages;
        this.taskConnections = taskConnections;
        this.downstreamStageIds = downstreamStageIds;
        this.id = id;
    }

    @Exported
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Exported
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Exported
    public List<String> getDownstreamStages() {
        return this.downstreamStages;
    }

    public void setDownstreamStages(List<String> downstreamStages) {
        this.downstreamStages = downstreamStages;
    }

    @Exported
    public Map<String, List<String>> getTaskConnections() {
        return this.taskConnections;
    }

    @Exported
    public long getId() {
        return this.id;
    }

    @Exported
    public List<Long> getDownstreamStageIds() {
        return this.downstreamStageIds;
    }

    public void setDownstreamStageIds(List<Long> downstreamStageIds) {
        this.downstreamStageIds = downstreamStageIds;
    }

    @Exported
    public Set<Change> getChanges() {
        return this.changes;
    }

    public void setChanges(Set<Change> changes) {
        this.changes = changes;
    }

    public void setTaskConnections(Map<String, List<String>> taskConnections) {
        this.taskConnections = taskConnections;
    }

    public static Stage getPrototypeStage(String name, List<Task> tasks) {
        return new Stage(name, tasks);
    }

    public static List<Stage> extractStages(AbstractProject firstProject, AbstractProject lastProject) throws PipelineException {
        LinkedHashMap stages = Maps.newLinkedHashMap();
        for (AbstractProject<?, ?> project : ProjectUtil.getAllDownstreamProjects(firstProject, lastProject).values()) {
            String stageName;
            Stage stage;
            PipelineProperty property;
            Task task = Task.getPrototypeTask(project, project.getFullName().equals(firstProject.getFullName()));
            if (lastProject != null && project.getFullName().equals(lastProject.getFullName())) {
                task.getDownstreamTasks().clear();
            }
            if ((property = (PipelineProperty)project.getProperty(PipelineProperty.class)) == null && project.getParent() instanceof AbstractProject) {
                property = (PipelineProperty)((AbstractProject)project.getParent()).getProperty(PipelineProperty.class);
            }
            if ((stage = (Stage)stages.get(stageName = property != null && !Strings.isNullOrEmpty((String)property.getStageName()) ? property.getStageName() : project.getDisplayName())) == null) {
                stage = Stage.getPrototypeStage(stageName, Collections.emptyList());
            }
            stages.put(stageName, Stage.getPrototypeStage(stage.getName(), Lists.newArrayList((Iterable)Iterables.concat(stage.getTasks(), Collections.singleton(task)))));
        }
        Collection<Stage> stagesResult = stages.values();
        return Stage.placeStages(firstProject, stagesResult);
    }

    public Stage createAggregatedStage(ItemGroup context, AbstractProject firstProject) {
        ArrayList<Task> stageTasks = new ArrayList<Task>();
        AbstractBuild versionBuild = this.getHighestBuild(firstProject, context);
        String stageVersion = null;
        if (versionBuild != null) {
            stageVersion = versionBuild.getDisplayName();
        }
        for (Task task : this.getTasks()) {
            stageTasks.add(task.getAggregatedTask(versionBuild, context));
        }
        return new Stage(this, stageTasks, stageVersion, this.id);
    }

    public Stage createLatestStage(ItemGroup context, AbstractBuild firstBuild) {
        ArrayList<Task> stageTasks = new ArrayList<Task>();
        for (Task task : this.getTasks()) {
            stageTasks.add(task.getLatestTask(context, firstBuild));
        }
        return new Stage(this, stageTasks, null, this.id);
    }

    public static List<Stage> placeStages(AbstractProject firstProject, Collection<Stage> stages) throws PipelineException {
        SimpleDirectedGraph graph = new SimpleDirectedGraph((EdgeFactory)new StageEdgeFactory());
        for (Stage stage : stages) {
            stage.setTaskConnections(Stage.getStageConnections(stage, stages));
            graph.addVertex((Object)stage);
            List<Stage> downstreamStages = Stage.getDownstreamStagesForStage(stage, stages);
            ArrayList downstreamStageNames = new ArrayList();
            ArrayList<Long> downstreamStageIds = new ArrayList<Long>();
            for (Stage downstream : downstreamStages) {
                downstreamStageNames.add(downstream.getName());
                downstreamStageIds.add(downstream.getId());
                graph.addVertex((Object)downstream);
                graph.addEdge((Object)stage, (Object)downstream, (Object)new Edge(stage, downstream));
            }
            stage.setDownstreamStages(downstreamStageNames);
            stage.setDownstreamStageIds(downstreamStageIds);
        }
        CycleDetector cycleDetector = new CycleDetector((DirectedGraph)graph);
        if (cycleDetector.detectCycles()) {
            Set stageSet = cycleDetector.findCycles();
            StringBuilder message = new StringBuilder("Circular dependencies between stages: ");
            for (Stage stage : stageSet) {
                message.append(stage.getName()).append(" ");
            }
            throw new PipelineException(message.toString());
        }
        List<List<Stage>> allPaths = Stage.findAllRunnablePaths(Stage.findStageForJob(firstProject.getRelativeNameFrom((ItemGroup)Jenkins.getInstance()), stages), (DirectedGraph<Stage, Edge>)graph);
        Collections.sort(allPaths, new Comparator<List<Stage>>(){

            @Override
            public int compare(List<Stage> stages1, List<Stage> stages2) {
                return stages2.size() - stages1.size();
            }
        });
        HashMap columnRowMap = Maps.newHashMap();
        ArrayList processedStages = Lists.newArrayList();
        for (int row = 0; row < allPaths.size(); ++row) {
            List<Stage> path = allPaths.get(row);
            for (int column = 0; column < path.size(); ++column) {
                Stage stage = path.get(column);
                if (processedStages.contains(stage)) continue;
                stage.setColumn(Math.max(stage.getColumn(), column));
                int effectiveColumn = stage.getColumn();
                Integer previousRowForThisColumn = (Integer)columnRowMap.get(effectiveColumn);
                int currentRowForThisColumn = previousRowForThisColumn == null ? 0 : previousRowForThisColumn + 1;
                columnRowMap.put(effectiveColumn, currentRowForThisColumn);
                stage.setRow(currentRowForThisColumn);
                processedStages.add(stage);
            }
        }
        ArrayList<Stage> result = new ArrayList<Stage>(stages);
        Stage.sortByRowsCols(result);
        return result;
    }

    private static Map<String, List<String>> getStageConnections(Stage stage, Collection<Stage> stages) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (int i = 0; i < stage.getTasks().size(); ++i) {
            Task task = stage.getTasks().get(i);
            for (int j = 0; j < task.getDownstreamTasks().size(); ++j) {
                String downstreamTask = task.getDownstreamTasks().get(j);
                Stage target = Stage.findStageForJob(downstreamTask, stages);
                if (stage.equals(target)) continue;
                if (result.get(task.getId()) == null) {
                    result.put(task.getId(), new ArrayList<String>(Collections.singleton(downstreamTask)));
                    continue;
                }
                ((List)result.get(task.getId())).add(downstreamTask);
            }
        }
        return result;
    }

    private static List<List<Stage>> findAllRunnablePaths(Stage start, DirectedGraph<Stage, Edge> graph) {
        LinkedList<List<Stage>> paths = new LinkedList<List<Stage>>();
        if (graph.outDegreeOf((Object)start) == 0) {
            LinkedList<Stage> path = new LinkedList<Stage>();
            path.add(start);
            paths.add(path);
        } else {
            for (Edge edge : graph.outgoingEdgesOf((Object)start)) {
                List<List<Stage>> allPathsFromTarget = Stage.findAllRunnablePaths(edge.getTarget(), graph);
                for (List<Stage> path : allPathsFromTarget) {
                    path.add(0, start);
                }
                paths.addAll(allPathsFromTarget);
            }
        }
        return paths;
    }

    protected static void sortByRowsCols(List<Stage> stages) {
        Collections.sort(stages, new Comparator<Stage>(){

            @Override
            public int compare(Stage stage1, Stage stage2) {
                int result = Integer.valueOf(stage1.getRow()).compareTo(stage2.getRow());
                if (result == 0) {
                    return Integer.valueOf(stage1.getColumn()).compareTo(stage2.getColumn());
                }
                return result;
            }
        });
    }

    private static List<Stage> getDownstreamStagesForStage(Stage stage, Collection<Stage> stages) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < stage.getTasks().size(); ++i) {
            Task task = stage.getTasks().get(i);
            for (int j = 0; j < task.getDownstreamTasks().size(); ++j) {
                String jobName = task.getDownstreamTasks().get(j);
                Stage target = Stage.findStageForJob(jobName, stages);
                if (target == null || target.getName().equals(stage.getName())) continue;
                result.add(target);
            }
        }
        return result;
    }

    @CheckForNull
    protected static Stage findStageForJob(String name, Collection<Stage> stages) {
        for (Stage stage : stages) {
            for (int j = 0; j < stage.getTasks().size(); ++j) {
                Task task = stage.getTasks().get(j);
                if (!task.getId().equals(name)) continue;
                return stage;
            }
        }
        return null;
    }

    @CheckForNull
    public AbstractBuild getHighestBuild(AbstractProject firstProject, ItemGroup context) {
        return this.getHighestBuild(firstProject, context, null);
    }

    @CheckForNull
    public AbstractBuild getHighestBuild(AbstractProject firstProject, ItemGroup context, Result minResult) {
        int highest = -1;
        for (Task task : this.getTasks()) {
            AbstractProject<?, ?> project = ProjectUtil.getProject(task.getId(), context);
            AbstractBuild firstBuild = this.getFirstUpstreamBuild(project, firstProject, minResult);
            if (firstBuild == null || firstBuild.getNumber() <= highest) continue;
            highest = firstBuild.getNumber();
        }
        if (highest > 0) {
            return firstProject.getBuildByNumber(highest);
        }
        return null;
    }

    @CheckForNull
    private AbstractBuild getFirstUpstreamBuild(AbstractProject<?, ?> project, AbstractProject<?, ?> first, Result minResult) {
        RunList builds = project.getBuilds();
        for (AbstractBuild build : builds) {
            AbstractBuild upstream;
            if (minResult != null && (build.isBuilding() || build.getResult().isWorseThan(minResult)) || (upstream = BuildUtil.getFirstUpstreamBuild(build, first)) == null || !upstream.getProject().equals(first)) continue;
            return upstream;
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("version", (Object)this.getVersion()).add("tasks", this.getTasks()).toString();
    }
}

