/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline.domain;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import java.util.List;
import se.diabol.jenkins.pipeline.domain.Component;
import se.diabol.jenkins.pipeline.domain.Pipeline;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.Stage;
import se.diabol.jenkins.pipeline.util.ProjectUtil;

public class DownstreamPipeline
extends Pipeline {
    public DownstreamPipeline(String name, AbstractProject firstProject, AbstractProject lastProject, List<Stage> stages) {
        super(name, firstProject, lastProject, stages);
    }

    @Override
    public List<Pipeline> createPipelineLatest(int noOfPipelines, ItemGroup context, boolean pagingEnabled, boolean showChanges, Component component) throws PipelineException {
        List<AbstractProject> firstProjects = ProjectUtil.getStartUpstreams(this.getFirstProject());
        List<AbstractBuild> builds = this.resolveBuilds(firstProjects);
        int totalNoOfPipelines = builds.size();
        component.setTotalNoOfPipelines(totalNoOfPipelines);
        int startIndex = DownstreamPipeline.getStartIndex(component, pagingEnabled, noOfPipelines);
        int retrieveSize = DownstreamPipeline.calculateRetreiveSize(component, pagingEnabled, noOfPipelines, totalNoOfPipelines);
        return this.getPipelines(builds.listIterator(startIndex), context, startIndex, retrieveSize, showChanges);
    }

    protected static int getStartIndex(Component component, boolean pagingEnabled, int noOfPipelines) {
        int startIndex = 0;
        if (pagingEnabled && !component.isFullScreenView()) {
            startIndex = (component.getCurrentPage() - 1) * noOfPipelines;
        }
        return startIndex;
    }

    protected static int calculateRetreiveSize(Component component, boolean pagingEnabled, int noOfPipelines, int totalNoOfPipelines) {
        int retrieveSize = noOfPipelines;
        if (pagingEnabled && !component.isFullScreenView()) {
            retrieveSize = Math.min(totalNoOfPipelines - (component.getCurrentPage() - 1) * noOfPipelines, noOfPipelines);
        }
        return retrieveSize;
    }

    @Override
    public boolean showUpstream() {
        return true;
    }
}

