/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.pipeline;

import hudson.model.Api;
import java.io.IOException;
import javax.servlet.ServletException;
import org.acegisecurity.AuthenticationException;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import se.diabol.jenkins.pipeline.PipelineView;
import se.diabol.jenkins.pipeline.trigger.TriggerException;

public class PipelineApi
extends Api {
    private final PipelineView view;

    public PipelineApi(PipelineView view) {
        super((Object)view);
        this.view = view;
    }

    public void doManualStep(StaplerRequest request, StaplerResponse response, @QueryParameter String project, @QueryParameter String upstream, @QueryParameter String buildId) throws IOException, ServletException {
        if (project != null && upstream != null && buildId != null) {
            try {
                this.view.triggerManual(project, upstream, buildId);
                response.setStatus(200);
            }
            catch (TriggerException e) {
                response.setStatus(500);
            }
            catch (AuthenticationException e) {
                response.setStatus(403);
            }
        } else {
            response.setStatus(406);
        }
    }

    public void doRebuildStep(StaplerRequest request, StaplerResponse response, @QueryParameter String project, @QueryParameter String buildId) throws IOException, ServletException {
        if (project != null && buildId != null) {
            try {
                this.view.triggerRebuild(project, buildId);
                response.setStatus(200);
            }
            catch (AuthenticationException e) {
                response.setStatus(403);
            }
        } else {
            response.setStatus(406);
        }
    }

    public void doInputStep(StaplerRequest request, StaplerResponse response, @QueryParameter String project, @QueryParameter String upstream, @QueryParameter String buildId) throws IOException, ServletException {
        this.doManualStep(request, response, project, upstream, buildId);
    }
}

