/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.model;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.status.Status;
import se.diabol.jenkins.pipeline.domain.status.StatusFactory;
import se.diabol.jenkins.pipeline.domain.task.ManualStep;
import se.diabol.jenkins.workflow.WorkflowApi;
import se.diabol.jenkins.workflow.api.Run;
import se.diabol.jenkins.workflow.api.Stage;
import se.diabol.jenkins.workflow.model.WorkflowStatus;
import se.diabol.jenkins.workflow.step.TaskAction;
import se.diabol.jenkins.workflow.util.Name;
import se.diabol.jenkins.workflow.util.Util;

public class Task
extends AbstractItem {
    private static final WorkflowApi workflowApi = new WorkflowApi(Jenkins.getInstance());
    private final String id;
    private final String link;
    private final Status status;
    private final ManualStep manual;
    private final String buildId;
    private final String description;

    public Task(String id, String name, Status status, String link, ManualStep manual, String description) {
        super(name);
        this.id = id;
        this.link = link;
        this.status = status;
        this.manual = manual;
        this.buildId = null;
        this.description = description;
    }

    @Exported
    public ManualStep getManualStep() {
        return this.manual;
    }

    @Exported
    public boolean isManual() {
        return this.manual != null;
    }

    @Exported
    public String getBuildId() {
        return this.buildId;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    @Exported
    public String getLink() {
        return this.link;
    }

    @Exported
    public Status getStatus() {
        return this.status;
    }

    @Exported
    public String getDescription() {
        return this.description;
    }

    public static List<Task> resolve(WorkflowRun build, FlowNode stageStartNode) {
        ArrayList<Task> result = new ArrayList<Task>();
        List stageNodes = FlowNodeUtil.getStageNodes((FlowNode)stageStartNode);
        List<FlowNode> taskNodes = Util.getTaskNodes(stageNodes);
        if (Task.taskNodesDefinedInStage(taskNodes)) {
            for (FlowNode flowNode : taskNodes) {
                TaskAction action = (TaskAction)flowNode.getAction(TaskAction.class);
                result.add(new Task(flowNode.getId(), action.getTaskName(), Task.resolveTaskStatus(build, stageStartNode), Task.taskLinkFor(build), null, null));
            }
        } else {
            Status stageStatus = Task.resolveTaskStatus(build, stageStartNode);
            result.add(Task.createStageTask(build, stageStartNode, stageStatus));
        }
        return result;
    }

    private static Task createStageTask(WorkflowRun build, FlowNode stageStartNode, Status stageStatus) {
        return new Task(stageStartNode.getId(), stageStartNode.getDisplayName(), stageStatus, Task.taskLinkFor(build), null, null);
    }

    private static String taskLinkFor(WorkflowRun build) {
        return "job/" + Name.of(build);
    }

    static boolean taskNodesDefinedInStage(List<FlowNode> taskNodes) {
        return !taskNodes.isEmpty();
    }

    private static Status resolveTaskStatus(WorkflowRun build, FlowNode stageStartNode) {
        List<Run> runs = workflowApi.getRunsFor(Name.of(build));
        Run run = Util.getRunById(runs, build.getNumber());
        Stage currentStage = run.getStageByName(stageStartNode.getDisplayName());
        if (currentStage == null) {
            return Task.resolveStatus(build, FlowNodeUtil.getStageNodes((FlowNode)stageStartNode), run.stages);
        }
        Status stageStatus = WorkflowStatus.of(currentStage);
        if (stageStatus.isRunning()) {
            stageStatus = Task.runningStatus(build, currentStage);
        }
        return stageStatus;
    }

    private static Status resolveStatus(WorkflowRun build, List<FlowNode> taskNodes, List<Stage> stages) {
        if (Result.FAILURE.equals(build.getResult())) {
            return StatusFactory.failed(Task.getStartTime(taskNodes), Task.getDuration(stages), false, null);
        }
        if (Task.isRunning(taskNodes) && !build.getExecution().isComplete()) {
            return Task.runningStatus(build);
        }
        if (Task.allExecuted(taskNodes)) {
            if (Task.failed(Util.head(taskNodes))) {
                return StatusFactory.failed(Task.getStartTime(taskNodes), Task.getDuration(stages), false, null);
            }
            return StatusFactory.success(Task.getStartTime(taskNodes), Task.getDuration(stages), false, null);
        }
        return StatusFactory.idle();
    }

    protected static boolean failed(FlowNode node) {
        return node != null && node.getError() != null;
    }

    private static Status runningStatus(WorkflowRun build) {
        long buildTimestamp = build.getTimeInMillis();
        int progress = Task.calculateProgress(buildTimestamp, build.getEstimatedDuration());
        return Task.runningStatus(buildTimestamp, progress);
    }

    private static Status runningStatus(WorkflowRun build, Stage stage) {
        int progress = Task.progressOfStage(build, stage);
        return Task.runningStatus(build.getTimeInMillis(), progress);
    }

    private static Status runningStatus(long buildTimestamp, int progress) {
        if (progress > 100) {
            progress = 99;
        }
        return StatusFactory.running(progress, buildTimestamp, System.currentTimeMillis() - buildTimestamp);
    }

    private static int progressOfStage(WorkflowRun build, Stage currentStage) {
        Run previousRun = workflowApi.lastFinishedRunFor(Name.of(build));
        if (!previousRun.hasStage(currentStage.name)) {
            return 99;
        }
        long stageStartTime = currentStage.startTimeMillis.getValue();
        long estimatedStageDuration = Stage.getDurationOfStageFromRun(previousRun, currentStage);
        return Task.calculateProgress(stageStartTime, estimatedStageDuration);
    }

    static int calculateProgress(long timestampFromBuild, long estimatedDuration) {
        return (int)Math.round(100.0 * (double)(System.currentTimeMillis() - timestampFromBuild) / (double)estimatedDuration);
    }

    private static boolean allExecuted(List<FlowNode> nodes) {
        for (FlowNode node : nodes) {
            if (NotExecutedNodeAction.isExecuted((FlowNode)node)) continue;
            return false;
        }
        return true;
    }

    static boolean isRunning(List<FlowNode> nodes) {
        if (nodes != null) {
            for (FlowNode node : nodes) {
                if (!node.isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    static long getStartTime(List<FlowNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            return TimingAction.getStartTime((FlowNode)nodes.get(0));
        }
        return 0L;
    }

    protected static long getDuration(List<Stage> stages) {
        long result = 0L;
        if (stages != null) {
            for (Stage stage : stages) {
                result += stage.durationMillis.longValue();
            }
        }
        return result;
    }
}

