/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.workflow.model.Task;
import se.diabol.jenkins.workflow.util.Util;

public class Stage
extends AbstractItem {
    private List<Task> tasks;
    private String version;
    private int row;
    private int column;
    private List<Stage> downstreamStages;
    private List<Long> downstreamStageIds;
    private long id;

    public Stage(String name, List<Task> tasks) {
        super(name);
        this.tasks = this.immutableListOf(tasks);
        this.id = PipelineUtils.getRandom();
    }

    private List<Task> immutableListOf(List<Task> tasks) {
        return tasks == null ? Collections.emptyList() : ImmutableList.copyOf(tasks);
    }

    @Exported
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    @Exported
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    @Exported
    public List<Stage> getDownstreamStages() {
        return this.downstreamStages;
    }

    @Exported
    public Map<String, List<String>> getTaskConnections() {
        if (this.hasNoDownstreamStages()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> taskIdToConnectionsMap = new HashMap<String, List<String>>();
        taskIdToConnectionsMap.put("" + this.getId(), this.getFirstDownstreamIdAsList());
        return taskIdToConnectionsMap;
    }

    protected List<String> getFirstDownstreamIdAsList() {
        Stage first = Util.head(this.getDownstreamStages());
        if (first == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(first.getId() + "");
    }

    protected boolean hasNoDownstreamStages() {
        return this.getDownstreamStages() == null || this.getDownstreamStages().isEmpty();
    }

    @Exported
    public long getId() {
        return this.id;
    }

    @Exported
    public List<Long> getDownstreamStageIds() {
        return this.downstreamStageIds;
    }

    static List<Stage> extractStages(WorkflowRun build, List<FlowNode> stageNodes) throws PipelineException {
        List<Stage> result = Stage.resolveStageNodes(build, stageNodes);
        for (int i = 0; i < result.size(); ++i) {
            Stage stage = result.get(i);
            if (i + 1 < result.size()) {
                stage.downstreamStages = Collections.singletonList(result.get(i + 1));
                stage.downstreamStageIds = Collections.singletonList(result.get(i + 1).getId());
            }
            stage.setColumn(i);
            stage.setRow(0);
        }
        return result;
    }

    private static List<Stage> resolveStageNodes(WorkflowRun build, List<FlowNode> stageNodes) {
        ArrayList<Stage> result = new ArrayList<Stage>();
        for (FlowNode stageNode : stageNodes) {
            List<Task> tasks = Task.resolve(build, stageNode);
            result.add(new Stage(stageNode.getDisplayName(), tasks));
        }
        return result;
    }
}

