/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.model;

import com.cloudbees.workflow.flownode.FlowNodeUtil;
import hudson.model.Job;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.AbstractItem;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.domain.TriggerCause;
import se.diabol.jenkins.pipeline.domain.UserInfo;
import se.diabol.jenkins.pipeline.domain.task.Task;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.workflow.model.Stage;

public class Pipeline
extends AbstractItem {
    private List<Stage> stages;
    private String version;
    private List<TriggerCause> triggeredBy;
    private Set<UserInfo> contributors;
    private String timestamp;
    private List<Change> changes;
    private long totalBuildTime;
    private Map<String, Task> allTasks = null;

    public Pipeline(String name, String version, List<Stage> stages, List<Change> changes, List<TriggerCause> triggeredBy, String timestamp) {
        super(name);
        this.stages = stages;
        this.version = version;
        this.changes = changes;
        this.triggeredBy = triggeredBy;
        this.timestamp = timestamp;
    }

    @Exported
    public List<Stage> getStages() {
        return this.stages;
    }

    @Exported
    public String getVersion() {
        return this.version;
    }

    @Exported
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported
    public boolean isAggregated() {
        return false;
    }

    @Exported
    public Set<UserInfo> getContributors() {
        return this.contributors;
    }

    @Exported
    public int getId() {
        return this.hashCode();
    }

    public void setChanges(List<Change> changes) {
        this.changes = changes;
    }

    @Exported
    public List<Change> getChanges() {
        return this.changes;
    }

    @Exported
    public long getTotalBuildTime() {
        return this.totalBuildTime;
    }

    @Exported
    public List<TriggerCause> getTriggeredBy() {
        return this.triggeredBy;
    }

    public static Pipeline resolve(WorkflowJob project, WorkflowRun build) throws PipelineException {
        String pipeLineTimestamp = PipelineUtils.formatTimestamp(build.getTimeInMillis());
        List stageNodes = FlowNodeUtil.getStageNodes((FlowExecution)build.getExecution());
        return new Pipeline("Pipeline", build.getDisplayName(), Stage.extractStages(build, stageNodes), Change.getChanges(build.getChangeSets()), TriggerCause.getTriggeredBy((Job)project, build), pipeLineTimestamp);
    }
}

