/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.DateTime;
import com.google.common.base.Objects;
import java.util.Map;
import se.diabol.jenkins.workflow.api.Run;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Stage {
    public final Map<String, ?> _links;
    public final String id;
    public final String name;
    public final String status;
    public final DateTime startTimeMillis;
    public final Long durationMillis;

    public Stage(@JsonProperty(value="_links") Map<String, ?> _links, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="status") String status, @JsonProperty(value="startTimeMillis") DateTime startTimeMillis, @JsonProperty(value="durationMillis") Long durationMillis) {
        this._links = _links;
        this.id = id;
        this.name = name;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.durationMillis = durationMillis;
    }

    public static long getDurationOfStageFromRun(Run previousRun, Stage currentStage) {
        Stage previouslyRunStage = previousRun.getStageByName(currentStage.name);
        if (previouslyRunStage == null || previouslyRunStage.durationMillis == null) {
            return -1L;
        }
        return previouslyRunStage.durationMillis;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Stage stage = (Stage)other;
        return Objects.equal(this._links, stage._links) && Objects.equal((Object)this.id, (Object)stage.id) && Objects.equal((Object)this.name, (Object)stage.name) && Objects.equal((Object)this.status, (Object)stage.status) && Objects.equal((Object)this.startTimeMillis, (Object)stage.startTimeMillis) && Objects.equal((Object)this.durationMillis, (Object)stage.durationMillis);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this._links, this.id, this.name, this.status, this.startTimeMillis, this.durationMillis});
    }

    public String toString() {
        return "Stage{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", status='" + this.status + '\'' + '}';
    }
}

