/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.api.client.util.DateTime;
import java.util.List;
import java.util.Map;
import se.diabol.jenkins.workflow.api.Stage;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Run {
    public final Map<String, ?> _links;
    public final String id;
    public final String name;
    public final String status;
    public final DateTime startTimeMillis;
    public final DateTime endTimeMillis;
    public final Long durationMillis;
    public final List<Stage> stages;

    public Run(@JsonProperty(value="_links") Map<String, ?> _links, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="status") String status, @JsonProperty(value="startTimeMillis") DateTime startTimeMillis, @JsonProperty(value="endTimeMillis") DateTime endTimeMillis, @JsonProperty(value="durationMillis") Long durationMillis, @JsonProperty(value="stages") List<Stage> stages) {
        this._links = _links;
        this.id = id;
        this.name = name;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
        this.endTimeMillis = endTimeMillis;
        this.durationMillis = durationMillis;
        this.stages = stages;
    }

    public boolean hasStage(String name) {
        for (Stage stage : this.stages) {
            String stageName = stage.name;
            if (stageName == null || !stageName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public Stage getStageByName(String name) {
        for (Stage stage : this.stages) {
            String stageName = stage.name;
            if (stageName == null || !stageName.equals(name)) continue;
            return stage;
        }
        return null;
    }

    public String toString() {
        return "Run{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", status='" + this.status + '\'' + '}';
    }
}

