/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public class Json {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T deserialize(String jsonResponse, Class<T> type) {
        return Json.deserialize(jsonResponse.getBytes(), type);
    }

    private static <T> T deserialize(byte[] json, Class<T> type) {
        try {
            return (T)Json.objectMapper().readValue(json, type);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
    }

    public static String serialize(Object serializable) {
        try {
            return Json.objectMapper().writeValueAsString(serializable);
        }
        catch (JsonProcessingException jpe) {
            throw new IllegalArgumentException(jpe);
        }
    }

    static ObjectMapper objectMapper() {
        return OBJECT_MAPPER;
    }
}

