/*
 * Decompiled with CFR 0.152.
 */
package se.diabol.jenkins.workflow;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import se.diabol.jenkins.pipeline.domain.Change;
import se.diabol.jenkins.pipeline.domain.PipelineException;
import se.diabol.jenkins.pipeline.util.JenkinsUtil;
import se.diabol.jenkins.pipeline.util.PipelineUtils;
import se.diabol.jenkins.pipeline.util.ProjectUtil;
import se.diabol.jenkins.workflow.model.Component;
import se.diabol.jenkins.workflow.model.Pipeline;

public class WorkflowPipelineView
extends View {
    public static final int DEFAULT_INTERVAL = 2;
    public static final int DEFAULT_NO_OF_PIPELINES = 3;
    private static final int MAX_NO_OF_PIPELINES = 50;
    private int updateInterval = 2;
    private int noOfPipelines = 3;
    private int noOfColumns = 1;
    private boolean allowPipelineStart = false;
    private boolean showChanges = false;
    private String theme = "default";
    private String project;
    private String description = null;
    private transient String error;

    @DataBoundConstructor
    public WorkflowPipelineView(String name) {
        super(name);
    }

    public WorkflowPipelineView(String name, ViewGroup owner) {
        super(name, owner);
    }

    public int getNoOfColumns() {
        return this.noOfColumns;
    }

    public void setNoOfColumns(int noOfColumns) {
        this.noOfColumns = noOfColumns;
    }

    public int getUpdateInterval() {
        if (this.updateInterval == 0) {
            this.updateInterval = 2;
        }
        return this.updateInterval;
    }

    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public int getNoOfPipelines() {
        return this.noOfPipelines;
    }

    public void setNoOfPipelines(int noOfPipelines) {
        this.noOfPipelines = noOfPipelines;
    }

    @Exported
    public boolean isAllowPipelineStart() {
        return this.allowPipelineStart;
    }

    public void setAllowPipelineStart(boolean allowPipelineStart) {
        this.allowPipelineStart = allowPipelineStart;
    }

    public boolean isShowChanges() {
        return this.showChanges;
    }

    public void setShowChanges(boolean showChanges) {
        this.showChanges = showChanges;
    }

    public String getTheme() {
        return this.theme == null ? "default" : this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    @Exported
    public String getLastUpdated() {
        return PipelineUtils.formatTimestamp(System.currentTimeMillis());
    }

    @Exported
    public String getDescription() {
        if (((View)this).description == null) {
            this.setDescription(this.description);
        }
        return ((View)this).description;
    }

    public void setDescription(String description) {
        ((View)this).description = description;
        this.description = description;
    }

    @Exported
    public String getError() {
        return this.error;
    }

    @Exported
    public List<Component> getPipelines() {
        try {
            if (this.project == null) {
                return Collections.emptyList();
            }
            WorkflowJob job = this.getWorkflowJob(this.project);
            List<Pipeline> pipelines = this.resolvePipelines(job);
            Component component = new Component(job.getName(), job, pipelines);
            this.error = null;
            return Collections.singletonList(component);
        }
        catch (PipelineException e) {
            this.error = e.getMessage();
            return Collections.emptyList();
        }
    }

    private List<Pipeline> resolvePipelines(WorkflowJob job) throws PipelineException {
        ArrayList<Pipeline> pipelines = new ArrayList<Pipeline>();
        if (job.getBuilds() == null) {
            return pipelines;
        }
        Iterator it = job.getBuilds().iterator();
        for (int i = 0; i < this.noOfPipelines && it.hasNext(); ++i) {
            WorkflowRun build = (WorkflowRun)it.next();
            Pipeline pipeline = this.resolvePipeline(job, build);
            pipelines.add(pipeline);
        }
        return pipelines;
    }

    private Pipeline resolvePipeline(WorkflowJob job, WorkflowRun build) throws PipelineException {
        Pipeline pipeline = Pipeline.resolve(job, build);
        if (this.showChanges) {
            pipeline.setChanges(this.getChangelog(build));
        }
        return pipeline;
    }

    private WorkflowJob getWorkflowJob(String projectName) throws PipelineException {
        WorkflowJob job = (WorkflowJob)WorkflowPipelineView.jenkins().getItem(projectName, (ItemGroup)WorkflowPipelineView.jenkins(), WorkflowJob.class);
        if (job == null) {
            throw new PipelineException("Failed to resolve job with name: " + projectName);
        }
        return job;
    }

    private List<Change> getChangelog(WorkflowRun build) {
        return Change.getChanges(build.getChangeSets());
    }

    public Collection<TopLevelItem> getItems() {
        return this.getOwnerItemGroup().getItems();
    }

    public boolean contains(TopLevelItem item) {
        return this.getItems().contains(item);
    }

    protected void submit(StaplerRequest req) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, req.getSubmittedForm());
    }

    public Item doCreateItem(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        if (!this.isDefault()) {
            return this.getOwner().getPrimaryView().doCreateItem(req, rsp);
        }
        return WorkflowPipelineView.jenkins().doCreateItem(req, rsp);
    }

    private static Jenkins jenkins() {
        return JenkinsUtil.getInstance();
    }

    @Extension
    public static class DescriptorImpl
    extends ViewDescriptor {
        public ListBoxModel doFillNoOfColumnsItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel options = new ListBoxModel();
            options.add("1", "1");
            options.add("2", "2");
            options.add("3", "3");
            return options;
        }

        public ListBoxModel doFillProjectItems(@AncestorInPath ItemGroup<?> context) {
            return ProjectUtil.fillAllProjects(context, WorkflowJob.class);
        }

        public ListBoxModel doFillNoOfPipelinesItems(@AncestorInPath ItemGroup<?> context) {
            ListBoxModel options = new ListBoxModel();
            for (int i = 1; i <= 50; ++i) {
                String opt = String.valueOf(i);
                options.add(opt, opt);
            }
            return options;
        }

        public FormValidation doCheckUpdateInterval(@QueryParameter String value) {
            int valueAsInt;
            try {
                valueAsInt = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((Throwable)e, (String)"Value must be an integer");
            }
            if (valueAsInt <= 0) {
                return FormValidation.error((String)"Value must be greater than 0");
            }
            return FormValidation.ok();
        }

        @Nonnull
        public String getDisplayName() {
            return "Delivery Pipeline View for Jenkins Pipelines";
        }
    }
}

